/* BdfServer - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.ficheform.builders.thesaurus;

import fr.exemole.bdfserver.api.BdfServerConstants;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.include.ThesaurusEntry;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import net.fichotheque.pointeurs.FichePointeur;
import net.mapeadores.util.annotation.Nullable;


/**
 *
 * @author Vincent Calame
 */
public final class ThesaurusEntryFactory {

    private ThesaurusEntryFactory() {

    }

    @Nullable
    public static ThesaurusEntry newInstance(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        String inputType = includeUi.getOptionValue(BdfServerConstants.INPUTTYPE_OPTION, BdfServerConstants.INPUT_TEXT);
        switch (inputType) {
            case BdfServerConstants.INPUT_CHECK: {
                ChoiceThesaurusEntryBuilder builder = ChoiceThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                if (builder != null) {
                    return builder.toChoiceThesaurusEntry();
                } else {
                    return null;
                }
            }
            case BdfServerConstants.INPUT_RADIO:
            case BdfServerConstants.INPUT_SELECT: {
                ChoiceThesaurusEntryBuilder builder = ChoiceThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                if (builder != null) {
                    ThesaurusEntry.Choice ltie = builder.toChoiceThesaurusEntry();
                    if (ltie.getValueList().size() > 1) {
                        TextThesaurusEntryBuilder builder2 = TextThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                        if (builder2 != null) {
                            return builder2.toTextThesaurusEntry();
                        } else {
                            return null;
                        }
                    } else {
                        return ltie;
                    }
                } else {
                    return null;
                }
            }
            case BdfServerConstants.INPUT_HIDDEN: {
                HiddenThesaurusEntryBuilder builder = HiddenThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                if (builder != null) {
                    return builder.toHiddenThesaurusEntry();
                } else {
                    return null;
                }
            }
            case BdfServerConstants.INPUT_NOTEDITABLE: {
                NotEditableThesaurusEntryBuilder builder = NotEditableThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                if (builder != null) {
                    return builder.toNotEditableThesaurusEntry();
                } else {
                    return null;
                }
            }
            case BdfServerConstants.INPUT_FICHESTYLE: {
                FicheStyleThesaurusEntryBuilder builder = FicheStyleThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                if (builder != null) {
                    return builder.toFicheStyleThesaurusEntry();
                } else {
                    return null;
                }
            }
            case BdfServerConstants.INPUT_TEXT:
            default: {
                TextThesaurusEntryBuilder builder = TextThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
                if (builder != null) {
                    return builder.toTextThesaurusEntry();
                } else {
                    return null;
                }
            }
        }
    }

}
