/* BdfServer - Copyright (c) 2024-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.ficheform.builders.thesaurus;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.include.SubsetItemValue;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.junction.Liaison;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.text.StringUtils;
import net.fichotheque.junction.Junctions;


/**
 *
 * @author Vincent Calame
 */
class MotcleValueListBuilder {

    private final List<SubsetItemValue> valueList = new ArrayList<SubsetItemValue>();

    MotcleValueListBuilder() {

    }

    boolean isEmpty() {
        return valueList.isEmpty();
    }

    void add(Motcle motcle, int weight) {
        String idalpha = motcle.getIdalpha();
        String value;
        if (idalpha != null) {
            value = idalpha;
        } else {
            value = String.valueOf(motcle.getId());
        }
        if (weight > 1) {
            value = value + "<" + weight + ">";
        }
        valueList.add(FicheFormUtils.toSubsetItemValue(value, weight, motcle));
    }

    void populateDefault(FicheFormParameters ficheFormParameters, IncludeUi includeUi, Thesaurus thesaurus) {
        String defaultValue = FicheFormUtils.getDefVal(ficheFormParameters, includeUi);
        if (defaultValue.length() == 0) {
            return;
        }
        String[] tokens = StringUtils.getTokens(defaultValue, ';', StringUtils.EMPTY_EXCLUDE);
        Set<Motcle> defaultSet = new HashSet<Motcle>();
        boolean withIdalpha = thesaurus.isIdalphaType();
        for (String token : tokens) {
            if (withIdalpha) {
                Motcle motcle = thesaurus.getMotcleByIdalpha(token);
                if (motcle != null) {
                    if (!defaultSet.contains(motcle)) {
                        defaultSet.add(motcle);
                        add(motcle, -1);
                    }
                }
            } else {
                try {
                    int motcleid = Integer.parseInt(token);
                    Motcle motcle = thesaurus.getMotcleById(motcleid);
                    if (motcle != null) {
                        if (!defaultSet.contains(motcle)) {
                            defaultSet.add(motcle);
                            add(motcle, -1);
                        }
                    }
                } catch (NumberFormatException nfe) {
                }
            }
        }
    }

    Collection<Liaison> populate(Junctions motcleJunctions, SubsetIncludeUi includeUi, boolean withWeight) {
        ExtendedIncludeKey extendedIncludeKey = includeUi.getExtendedIncludeKey();
        Collection<Liaison> liaisons = JunctionUtils.filter(motcleJunctions, extendedIncludeKey);
        if ((!withWeight) || (extendedIncludeKey.hasWeightFilter())) {
            for (Liaison liaison : liaisons) {
                add((Motcle) liaison.getSubsetItem(), -1);
            }
        } else {
            for (Liaison liaison : liaisons) {
                add((Motcle) liaison.getSubsetItem(), liaison.getTie().getWeight());
            }
        }
        return liaisons;
    }

    List<SubsetItemValue> toList() {
        return FicheFormUtils.wrap(valueList.toArray(new SubsetItemValue[valueList.size()]));
    }

}
