/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml.handlers;

import net.mapeadores.util.xml.handlers.ElementHandler;
import org.xml.sax.Attributes;

public class SimpleElementHandler
implements ElementHandler {
    private final StringBuilder buf = new StringBuilder();
    private final int type;
    private int subCount = 0;

    public SimpleElementHandler(int type) {
        this.type = type;
    }

    @Override
    public void processStartElement(String tagname, Attributes attributes) {
        ++this.subCount;
        this.buf.append("<");
        this.buf.append(tagname);
        this.buf.append(">");
    }

    @Override
    public boolean processEndElement(String tagname) {
        if (this.subCount == 0) {
            return true;
        }
        --this.subCount;
        this.buf.append("</");
        this.buf.append(tagname);
        this.buf.append(">");
        return false;
    }

    @Override
    public void processText(char[] ch, int start, int length) {
        this.buf.append(ch, start, length);
    }

    public String getText() {
        return this.buf.toString().trim();
    }

    public int getType() {
        return this.type;
    }
}

