/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.mapeadores.util.exceptions.ExceptionsUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.LangFilter;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.DefaultXMLWriter;
import net.mapeadores.util.xml.DocumentFragmentHolder;
import net.mapeadores.util.xml.XMLWriter;
import net.mapeadores.util.xml.XmlProducer;
import net.mapeadores.util.xml.ns.NameSpace;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final DocumentFragmentHolder EMPTY_DOCUMENTFRAGMENTHOLDER = new EmptyDocumentFragmentHolder();
    private static final short BALISE_AUTOFERMANTE = 1;
    private static final short BALISE_FERMANTE = 2;
    private static final short BALISE_OUVRANTE = 3;

    public static void addElement(AppendableXMLWriter xmlWriter, Element element, boolean elementInclude) throws IOException {
        int i;
        int count;
        String tagName = element.getTagName();
        if (elementInclude) {
            xmlWriter.startOpenTag(tagName);
            if (element.hasAttributes()) {
                NamedNodeMap map = element.getAttributes();
                count = map.getLength();
                for (i = 0; i < count; ++i) {
                    Attr attribute = (Attr)map.item(i);
                    xmlWriter.addAttribute(attribute.getName(), attribute.getValue());
                }
            }
        }
        NodeList children = element.getChildNodes();
        if (elementInclude) {
            if (children.getLength() == 0) {
                xmlWriter.closeEmptyTag();
                return;
            }
            xmlWriter.endOpenTag();
        }
        count = children.getLength();
        for (i = 0; i < count; ++i) {
            Node node = children.item(i);
            if (node instanceof Text) {
                xmlWriter.append(((Text)node).getData());
                continue;
            }
            if (!(node instanceof Element)) continue;
            XMLUtils.addElement(xmlWriter, (Element)node, true);
        }
        if (elementInclude) {
            xmlWriter.closeTag(tagName);
        }
    }

    public static void writeDomTree(Document doc, OutputStream outputStream) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        transformer.transform(source, result);
    }

    public static void writeTabs(Appendable appendable, int tabCount) throws IOException {
        if (tabCount > -1) {
            appendable.append('\n');
            for (int i = 0; i < tabCount; ++i) {
                appendable.append('\t');
            }
        }
    }

    public static String escape(String s) {
        StringBuilder buf = new StringBuilder();
        try {
            XMLUtils.writeEscape((Appendable)buf, s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void writeEscape(Appendable appendable, String s) throws IOException {
        if (s == null || s.length() == 0) {
            return;
        }
        char[] caracs = s.toCharArray();
        block8: for (int i = 0; i < caracs.length; ++i) {
            if (caracs[i] < ' ') {
                appendable.append(' ');
                continue;
            }
            switch (caracs[i]) {
                case '&': {
                    appendable.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    appendable.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    appendable.append("&apos;");
                    continue block8;
                }
                case '<': {
                    appendable.append("&lt;");
                    continue block8;
                }
                case '>': {
                    appendable.append("&gt;");
                    continue block8;
                }
                case '\u00a0': {
                    appendable.append("&#x00A0;");
                    continue block8;
                }
                default: {
                    appendable.append(caracs[i]);
                }
            }
        }
    }

    public static void writeTechEscape(Appendable appendable, String s) throws IOException {
        if (s == null || s.length() == 0) {
            return;
        }
        char[] caracs = s.toCharArray();
        block7: for (int i = 0; i < caracs.length; ++i) {
            if (caracs[i] < ' ') {
                appendable.append(' ');
                continue;
            }
            switch (caracs[i]) {
                case '&': {
                    appendable.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    appendable.append("&quot;");
                    continue block7;
                }
                case '<': {
                    appendable.append("&lt;");
                    continue block7;
                }
                case '>': {
                    appendable.append("&gt;");
                    continue block7;
                }
                case '\u00a0': {
                    appendable.append("&#x00A0;");
                    continue block7;
                }
                default: {
                    appendable.append(caracs[i]);
                }
            }
        }
    }

    public static void writeEscape(Appendable appendable, char carac) throws IOException {
        if (carac < ' ') {
            appendable.append(' ');
        } else {
            switch (carac) {
                case '&': {
                    appendable.append("&amp;");
                    break;
                }
                case '\"': {
                    appendable.append("&quot;");
                    break;
                }
                case '\'': {
                    appendable.append("&apos;");
                    break;
                }
                case '<': {
                    appendable.append("&lt;");
                    break;
                }
                case '>': {
                    appendable.append("&gt;");
                    break;
                }
                case '\u00a0': {
                    appendable.append("&#x00A0;");
                    break;
                }
                default: {
                    appendable.append(carac);
                }
            }
        }
    }

    public static String cleanString(String s) {
        return StringUtils.cleanString(s, true);
    }

    public static String cleanString(String s, boolean trim) {
        return StringUtils.cleanString(s, trim);
    }

    public static String getData(Element el) {
        return XMLUtils.getData(el, true);
    }

    public static String getData(Element el, boolean trim) {
        String s = XMLUtils.getRawData(el);
        return XMLUtils.cleanString(s, trim);
    }

    public static CleanedString toCleanedString(Element el) {
        String s = XMLUtils.getRawData(el);
        return CleanedString.newInstance(s);
    }

    public static String getRawData(Element el) {
        StringBuilder buf = new StringBuilder();
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String data;
            Node nd = list.item(i);
            short nodeType = nd.getNodeType();
            if (nodeType != 3 && nodeType != 4 || (data = ((Text)nd).getData()) == null) continue;
            buf.append(data);
        }
        return buf.toString();
    }

    public static Element getFirstElement(Element el) {
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node nd = list.item(i);
            if (nd.getNodeType() != 1) continue;
            return (Element)nd;
        }
        return null;
    }

    public static void writeAttribute(Appendable appendable, String attributename, String value) throws IOException {
        if (value != null && value.length() > 0) {
            appendable.append(' ');
            appendable.append(attributename);
            appendable.append("=\"");
            XMLUtils.writeEscape(appendable, value);
            appendable.append('\"');
        }
    }

    public static void writeTag(Appendable appendable, String tagname, String value, int tabCount) throws IOException {
        if (value != null && value.length() > 0) {
            XMLUtils.writeTabs(appendable, tabCount);
            appendable.append("<");
            appendable.append(tagname);
            appendable.append(">");
            XMLUtils.writeEscape(appendable, value);
            appendable.append("</");
            appendable.append(tagname);
            appendable.append(">");
        }
    }

    public static XmlProducer toXmlProducer(String xml) {
        return new SimpleXmlProducer(xml);
    }

    public static String testXml(File xmlFile) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docbuilder.parse(xmlFile);
            return null;
        }
        catch (SAXException saxException) {
            return ExceptionsUtils.getSAXExceptionMessage(saxException);
        }
        catch (Exception e) {
            return ExceptionsUtils.getMessage(e);
        }
    }

    public static String testXml(String xmlString) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xmlString));
            Document document = docbuilder.parse(inputSource);
            return null;
        }
        catch (SAXException saxException) {
            return ExceptionsUtils.getSAXExceptionMessage(saxException);
        }
        catch (Exception e) {
            return ExceptionsUtils.getMessage(e);
        }
    }

    public static String testXml(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            Document document = docbuilder.parse(inputSource);
            return null;
        }
        catch (SAXException saxException) {
            return ExceptionsUtils.getSAXExceptionMessage(saxException);
        }
        catch (Exception e) {
            return ExceptionsUtils.getMessage(e);
        }
    }

    public static void addXmlLangAttribute(XMLWriter xmlWriter, Lang lang) throws IOException {
        if (lang != null) {
            xmlWriter.addAttribute("xml:lang", lang.toString());
        }
    }

    public static void addLibElement(XMLWriter xmlWriter, Lang lang, String lib) throws IOException {
        xmlWriter.startOpenTag("lib");
        if (lang != null) {
            xmlWriter.addAttribute("xml:lang", lang.toString());
        }
        xmlWriter.endOpenTag();
        xmlWriter.addText(lib);
        xmlWriter.closeTag("lib", false);
    }

    public static void addLibElements(XMLWriter xmlWriter, Labels labels) throws IOException {
        XMLUtils.addLibElements(xmlWriter, labels, null);
    }

    public static void addLibElements(XMLWriter xmlWriter, Labels labels, LangFilter langFilter) throws IOException {
        for (Label label : labels) {
            if (langFilter != null && !langFilter.accept(label.getLang())) continue;
            XMLUtils.addLibElement(xmlWriter, label.getLang(), label.getLabelString());
        }
    }

    public static AppendableXMLWriter toXMLWriter(Appendable appendable) {
        DefaultXMLWriter xmlWriter = new DefaultXMLWriter();
        xmlWriter.setAppendable(appendable);
        return xmlWriter;
    }

    public static AppendableXMLWriter toXMLWriter(Appendable appendable, int indentLength) {
        DefaultXMLWriter xmlWriter = new DefaultXMLWriter();
        xmlWriter.setAppendable(appendable);
        xmlWriter.setIndentLength(indentLength);
        return xmlWriter;
    }

    public static AppendableXMLWriter toXMLWriter(Appendable appendable, int indentLength, boolean aposEscaped) {
        DefaultXMLWriter xmlWriter = new DefaultXMLWriter();
        xmlWriter.setAppendable(appendable);
        xmlWriter.setIndentLength(indentLength);
        xmlWriter.setAposEscaped(aposEscaped);
        return xmlWriter;
    }

    public static void appendStylesheet(AppendableXMLWriter xmlWriter, String href, String type) throws IOException {
        xmlWriter.appendIndent();
        xmlWriter.append("<?xml-stylesheet href=\"");
        xmlWriter.append(href);
        xmlWriter.append("\" type=\"");
        xmlWriter.append(type);
        xmlWriter.append("\"?>");
    }

    public static void appendDocType(AppendableXMLWriter xmlWriter, String doctype) throws IOException {
        xmlWriter.appendIndent();
        xmlWriter.append("<!DOCTYPE ");
        xmlWriter.append(doctype);
        xmlWriter.append(">");
    }

    public static void appendNameSpaceAttribute(AppendableXMLWriter xmlWriter, NameSpace nameSpace) throws IOException {
        String prefix = nameSpace.getPrefix();
        String name = nameSpace.getName();
        xmlWriter.append(' ');
        xmlWriter.append("xmlns");
        if (prefix.length() > 0) {
            xmlWriter.append(':');
            xmlWriter.append(prefix);
        }
        xmlWriter.append('=');
        xmlWriter.append('\"');
        xmlWriter.addText(name);
        xmlWriter.append('\"');
    }

    public static void appendXmlDeclaration(AppendableXMLWriter xmlWriter) throws IOException {
        xmlWriter.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public static String indent(String xml) {
        if (xml.length() < 4) {
            return xml;
        }
        if (xml.startsWith(">")) {
            return xml;
        }
        StringBuilder buf = new StringBuilder();
        XMLUtils.buildIndent(buf, xml, 0, 0);
        return buf.toString();
    }

    private static void buildIndent(StringBuilder buf, String xml, int currentIndex, int indentation) {
        int idx = xml.indexOf("> <", currentIndex);
        if (idx == -1) {
            buf.append(xml, currentIndex, xml.length());
            return;
        }
        buf.append(xml, currentIndex, idx);
        buf.append('>');
        buf.append('\n');
        indentation = XMLUtils.checkIndentation(xml, idx, indentation);
        for (int i = 0; i < indentation; ++i) {
            buf.append("  ");
        }
        buf.append('<');
        XMLUtils.buildIndent(buf, xml, idx + 3, indentation);
    }

    private static int checkIndentation(String xml, int idx, int indentation) {
        boolean closingNext = XMLUtils.isClosingNext(xml, idx);
        short type = XMLUtils.getPreviousType(xml, idx);
        switch (type) {
            case 1: {
                if (!closingNext) break;
                --indentation;
                break;
            }
            case 3: {
                if (closingNext) break;
                ++indentation;
                break;
            }
            case 2: {
                if (!closingNext) break;
                --indentation;
            }
        }
        if (indentation < 0) {
            indentation = 0;
        }
        return indentation;
    }

    private static boolean isClosingNext(String xml, int idx) {
        if ((idx += 3) < xml.length()) {
            return xml.charAt(idx) == '/';
        }
        return false;
    }

    private static short getPreviousType(String xml, int idx) {
        char prev = xml.charAt(idx - 1);
        if (prev == '/') {
            return 1;
        }
        for (int i = idx - 1; i >= 0; --i) {
            char carac = xml.charAt(i);
            if (carac != '<') continue;
            if (xml.charAt(i + 1) == '/') {
                return 2;
            }
            return 3;
        }
        return 3;
    }

    private static class SimpleXmlProducer
    implements XmlProducer {
        private final String xml;

        private SimpleXmlProducer(String xml) {
            this.xml = xml;
        }

        @Override
        public void writeXml(Appendable appendable) throws IOException {
            appendable.append(this.xml);
        }
    }

    private static class EmptyDocumentFragmentHolder
    implements DocumentFragmentHolder {
        private EmptyDocumentFragmentHolder() {
        }

        @Override
        public DocumentFragment getFragment(String fragmentKey) {
            return null;
        }
    }
}

