/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.NestedLibraryException;
import net.mapeadores.util.exceptions.NestedSAXException;
import net.mapeadores.util.exceptions.ResponseCodeException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtils {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    private DOMUtils() {
    }

    public static void readChildren(Element parentElement, Consumer<Element> elementConsumer) {
        NodeList nodeList = parentElement.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            elementConsumer.accept(element);
        }
    }

    public static String readSimpleElement(Element element) {
        return DOMUtils.readSimpleElement(element, true);
    }

    public static String readSimpleElement(Element element, boolean trim) {
        Node nd = element.getFirstChild();
        if (nd != null && (nd.getNodeType() == 3 || nd.getNodeType() == 4)) {
            String result = ((Text)nd).getData();
            if (result == null) {
                return "";
            }
            return StringUtils.cleanString(result, trim);
        }
        return "";
    }

    public static CleanedString contentToCleanedString(Element element) {
        Node nd = element.getFirstChild();
        if (nd != null && (nd.getNodeType() == 3 || nd.getNodeType() == 4)) {
            String result = ((Text)nd).getData();
            return CleanedString.newInstance(result);
        }
        return null;
    }

    public static Document parseDocument(DocStream docStream) throws SAXException, IOException {
        DocumentBuilder docBuilder = DOMUtils.newDocumentBuilder();
        try (InputStream is = docStream.getInputStream();){
            String charset = docStream.getCharset();
            Document document = charset == null ? docBuilder.parse(is) : docBuilder.parse(new InputSource(new BufferedReader(new InputStreamReader(is, charset))));
            Document document2 = document;
            return document2;
        }
    }

    public static Document parseDocument(File f) throws SAXException, IOException {
        return DOMUtils.newDocumentBuilder().parse(f);
    }

    public static Document parseDocument(InputSource inputSource) throws SAXException, IOException {
        return DOMUtils.newDocumentBuilder().parse(inputSource);
    }

    public static Document parseDocument(InputStream inputStream) throws SAXException, IOException {
        return DOMUtils.newDocumentBuilder().parse(inputStream);
    }

    public static Document parseDocument(URL url) throws SAXException, ResponseCodeException, IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.connect();
        int code = urlConnection.getResponseCode();
        if (code != 200) {
            throw new ResponseCodeException(code);
        }
        try (InputStream is = urlConnection.getInputStream();){
            Document document = DOMUtils.parseDocument(is);
            return document;
        }
    }

    public static Document parseDocument(Reader reader) throws SAXException, IOException {
        return DOMUtils.parseDocument(new InputSource(reader));
    }

    public static Document parseDocument(String s) throws SAXException {
        try {
            return DOMUtils.parseDocument(new InputSource(new StringReader(s)));
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException(ioe);
        }
    }

    public static Document readDocument(DocStream docStream) {
        try {
            return DOMUtils.parseDocument(docStream);
        }
        catch (SAXException saxe) {
            throw new NestedSAXException(saxe);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public static Document readDocument(File f) {
        try {
            return DOMUtils.parseDocument(f);
        }
        catch (SAXException saxe) {
            throw new NestedSAXException(saxe);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public static Document readDocument(InputSource inputSource) {
        DocumentBuilder docBuilder = DOMUtils.newDocumentBuilder();
        try {
            Document document = docBuilder.parse(inputSource);
            return document;
        }
        catch (SAXException saxe) {
            throw new NestedSAXException(saxe);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public static Document readDocument(InputStream inputStream) {
        try {
            return DOMUtils.parseDocument(inputStream);
        }
        catch (SAXException saxe) {
            throw new NestedSAXException(saxe);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public static Document readDocument(Reader reader) {
        return DOMUtils.readDocument(new InputSource(reader));
    }

    public static Document readDocument(String xmlString) {
        return DOMUtils.readDocument(new InputSource(new StringReader(xmlString)));
    }

    public static synchronized DocumentBuilder newDocumentBuilder() {
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new NestedLibraryException(pce);
        }
    }

    public static Document newDocument() {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new NestedLibraryException(pce);
        }
    }
}

