/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.search;

import net.mapeadores.util.text.search.MultiSearchToken;
import net.mapeadores.util.text.search.SimpleSearchToken;

public class SearchUtils {
    private SearchUtils() {
    }

    public static SimpleSearchToken toSimpleSearchToken(String tokenString, int searchType) {
        return new DefaultSimpleSearchToken(tokenString, searchType);
    }

    public static MultiSearchToken toMultiSearchToken(SimpleSearchToken[] array) {
        return new ArrayMultiSearchToken(array);
    }

    public static String toCompleteString(SimpleSearchToken token) {
        String tokenString = token.getTokenString();
        int searchType = token.getSearchType();
        if (searchType == 0) {
            return tokenString;
        }
        StringBuilder buf = new StringBuilder(tokenString.length() + 2);
        if ((searchType & 2) != 0) {
            buf.append('*');
        }
        buf.append(tokenString);
        if ((searchType & 1) != 0) {
            buf.append('*');
        }
        return buf.toString();
    }

    private static class DefaultSimpleSearchToken
    implements SimpleSearchToken {
        private final int searchType;
        private final String tokenString;

        private DefaultSimpleSearchToken(String tokenString, int searchType) {
            this.tokenString = tokenString;
            this.searchType = searchType;
        }

        @Override
        public int getSearchType() {
            return this.searchType;
        }

        @Override
        public String getTokenString() {
            return this.tokenString;
        }
    }

    private static class ArrayMultiSearchToken
    implements MultiSearchToken {
        private final SimpleSearchToken[] subtokenArray;

        public ArrayMultiSearchToken(SimpleSearchToken[] subtokenArray) {
            this.subtokenArray = subtokenArray;
        }

        @Override
        public int getSubtokenCount() {
            return this.subtokenArray.length;
        }

        @Override
        public SimpleSearchToken getSubtoken(int i) {
            return this.subtokenArray[i];
        }
    }
}

