/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.Phrase;
import net.mapeadores.util.text.PhraseCache;
import net.mapeadores.util.text.Phrases;

public class PhrasesBuilder {
    private final Map<String, LabelChangeBuilder> builderMap = new LinkedHashMap<String, LabelChangeBuilder>();

    public LabelChangeBuilder getPhraseBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        LabelChangeBuilder builder = this.builderMap.get(name);
        if (builder == null) {
            builder = new LabelChangeBuilder();
            this.builderMap.put(name, builder);
        }
        return builder;
    }

    public Phrases toPhrases() {
        HashMap<String, Phrase> phraseMap = new HashMap<String, Phrase>();
        int size = this.builderMap.size();
        Phrase[] phraseArray = new Phrase[size];
        int p = 0;
        for (Map.Entry<String, LabelChangeBuilder> entry : this.builderMap.entrySet()) {
            String name = entry.getKey();
            Phrase phrase = entry.getValue().toPhrase(name);
            phraseMap.put(name, phrase);
            phraseArray[p] = phrase;
            ++p;
        }
        return new InternalPhrases(phraseArray, phraseMap);
    }

    public static Phrases toPhrases(Map<String, PhraseCache> cacheMap) {
        ArrayList<Phrase> tempList = new ArrayList<Phrase>();
        HashMap<String, Phrase> phraseMap = new HashMap<String, Phrase>();
        for (Map.Entry<String, PhraseCache> entry : cacheMap.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            Phrase phrase = entry.getValue().getPhrase();
            tempList.add(phrase);
            phraseMap.put(name, phrase);
        }
        Phrase[] phraseArray = tempList.toArray(new Phrase[tempList.size()]);
        return new InternalPhrases(phraseArray, phraseMap);
    }

    private static class InternalPhrases
    extends AbstractList<Phrase>
    implements Phrases {
        private final Phrase[] phraseArray;
        private final Map<String, Phrase> phraseMap;

        private InternalPhrases(Phrase[] phraseArray, Map<String, Phrase> phraseMap) {
            this.phraseArray = phraseArray;
            this.phraseMap = phraseMap;
        }

        @Override
        public int size() {
            return this.phraseArray.length;
        }

        @Override
        public Phrase get(int index) {
            return this.phraseArray[index];
        }

        @Override
        public Phrase getPhrase(String name) {
            return this.phraseMap.get(name);
        }
    }
}

