/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrase;

public class LabelChangeBuilder {
    private final Set<Lang> removedLangSet = new LinkedHashSet<Lang>();
    private final Map<Lang, Label> labelMap = new LinkedHashMap<Lang, Label>();

    public LabelChangeBuilder putLabels(Labels labels) {
        for (Label label : labels) {
            this.putLabel(label);
        }
        return this;
    }

    public LabelChangeBuilder putLabel(Label label) {
        Lang lang = label.getLang();
        this.labelMap.put(lang, label);
        this.removedLangSet.remove(lang);
        return this;
    }

    public Label putLabel(Lang lang, CharSequence charSequence) {
        return this.putLabel(lang, CleanedString.newInstance(charSequence));
    }

    public Label putLabel(Lang lang, CleanedString cleanedString) {
        if (cleanedString == null) {
            this.removedLangSet.add(lang);
            this.labelMap.remove(lang);
            return null;
        }
        Label label = LabelUtils.toLabel(lang, cleanedString);
        this.labelMap.put(lang, label);
        this.removedLangSet.remove(lang);
        return label;
    }

    public int getAddedLabelCount() {
        return this.labelMap.size();
    }

    public Label getLabel(Lang lang) {
        return this.labelMap.get(lang);
    }

    public void putRemovedLang(Lang lang) {
        this.removedLangSet.add(lang);
        this.labelMap.remove(lang);
    }

    public void merge(LabelChangeBuilder otherLabelChangeBuilder) {
        for (Lang lang : otherLabelChangeBuilder.removedLangSet) {
            if (this.labelMap.containsKey(lang)) continue;
            this.removedLangSet.add(lang);
        }
        for (Map.Entry entry : otherLabelChangeBuilder.labelMap.entrySet()) {
            Lang otherLang = (Lang)entry.getKey();
            if (this.labelMap.containsKey(otherLang)) continue;
            this.labelMap.put(otherLang, (Label)entry.getValue());
            this.removedLangSet.remove(otherLang);
        }
    }

    public void clear() {
        this.removedLangSet.clear();
        this.labelMap.clear();
    }

    public LabelChangeBuilder filterRealChanges(Labels currentLabels, LabelChange labelChange) {
        for (Label label : labelChange.getChangedLabels()) {
            Label currentLabel = currentLabels.getLabel(label.getLang());
            if (currentLabel != null && currentLabel.getLabelString().equals(label.getLabelString())) continue;
            this.putLabel(label);
        }
        for (Lang lang : labelChange.getRemovedLangList()) {
            if (currentLabels.getLabel(lang) == null) continue;
            this.putRemovedLang(lang);
        }
        return this;
    }

    public LabelChange toLabelChange() {
        Langs removedLangList = LangsUtils.wrap(this.removedLangSet);
        return new InternalLabelChange(this.toLabels(), removedLangList);
    }

    public Labels toLabels() {
        return LabelUtils.toLabels(this.labelMap);
    }

    public Phrase toPhrase(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Label[] labelArray = this.labelMap.values().toArray(new Label[this.labelMap.size()]);
        return new InternalPhrase(name, new HashMap<Lang, Label>(this.labelMap), labelArray);
    }

    public static LabelChangeBuilder init() {
        return new LabelChangeBuilder();
    }

    private static class InternalLabelChange
    implements LabelChange {
        private final Labels changedLabels;
        private final List<Lang> removedLangList;

        private InternalLabelChange(Labels changedLabels, List<Lang> removedLangList) {
            this.changedLabels = changedLabels;
            this.removedLangList = removedLangList;
        }

        @Override
        public Labels getChangedLabels() {
            return this.changedLabels;
        }

        @Override
        public List<Lang> getRemovedLangList() {
            return this.removedLangList;
        }
    }

    private static class InternalPhrase
    extends AbstractList<Label>
    implements Phrase {
        private final String name;
        private final Label[] labelArray;
        private final Map<Lang, Label> labelMap;

        private InternalPhrase(String name, Map<Lang, Label> labelMap, Label[] labelArray) {
            this.name = name;
            this.labelArray = labelArray;
            this.labelMap = labelMap;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Label getLabel(Lang lang) {
            return this.labelMap.get(lang);
        }

        @Override
        public int size() {
            return this.labelArray.length;
        }

        @Override
        public Label get(int index) {
            return this.labelArray[index];
        }
    }
}

