/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.text.StringUtils;

public final class CleanedString
implements CharSequence {
    private final String string;

    private CleanedString(String string) {
        this.string = string;
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(index);
    }

    @Override
    public int length() {
        return this.string.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.string.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.string;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        CleanedString otherCleanedString = (CleanedString)other;
        return otherCleanedString.string.equals(this.string);
    }

    @Nullable
    public static CleanedString newInstance(@Nullable CharSequence cs) {
        if (cs == null) {
            return null;
        }
        if (cs instanceof CleanedString) {
            return (CleanedString)cs;
        }
        String s = StringUtils.cleanString(cs);
        if (s.length() == 0) {
            return null;
        }
        if (s.equals(cs)) {
            return new CleanedString((String)cs);
        }
        return new CleanedString(s);
    }
}

