/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class PrimUtils {
    public static final List<Integer> EMPTY_LIST = Collections.emptyList();
    static long MASK_INT2 = 0xFFFFFFFFL;

    private PrimUtils() {
    }

    public static long toLong(int int1, int int2) {
        long long1 = int1;
        long long2 = int2;
        return (long1 <<= 32) | (long2 &= MASK_INT2);
    }

    public static Long toLongObject(int int1, int int2) {
        return PrimUtils.toLong(int1, int2);
    }

    public static int getInt1(long l) {
        return (int)(l >>> 32);
    }

    public static int getInt2(long l) {
        return (int)l;
    }

    public static boolean equalsInt1(long l, int i) {
        return PrimUtils.getInt1(l) == i;
    }

    public static boolean equalsInt2(long l, int i) {
        return PrimUtils.getInt2(l) == i;
    }

    public static int[] toIntArray(List<Integer> integerList) {
        int size = integerList.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = integerList.get(i);
        }
        return result;
    }

    public static Integer[] toArray(Collection<Integer> integers) {
        return integers.toArray(new Integer[integers.size()]);
    }

    public static List<Integer> wrap(Integer[] array) {
        return new IntegerList(array);
    }

    public static List<Integer> wrap(int[] array) {
        return new PrimIntegerList(array);
    }

    public static void convertInt(int value, byte[] bytes) {
        bytes[0] = (byte)(0xFF & value >> 24);
        bytes[1] = (byte)(0xFF & value >> 16);
        bytes[2] = (byte)(0xFF & value >> 8);
        bytes[3] = (byte)(0xFF & value);
    }

    public static void convertInt(int value, byte[] bytes, int start) {
        bytes[start] = (byte)(0xFF & value >> 24);
        bytes[start + 1] = (byte)(0xFF & value >> 16);
        bytes[start + 2] = (byte)(0xFF & value >> 8);
        bytes[start + 3] = (byte)(0xFF & value);
    }

    public static void convertLong(long value, byte[] bytes) {
        bytes[0] = (byte)(0xFFL & value >> 56);
        bytes[1] = (byte)(0xFFL & value >> 48);
        bytes[2] = (byte)(0xFFL & value >> 40);
        bytes[3] = (byte)(0xFFL & value >> 32);
        bytes[4] = (byte)(0xFFL & value >> 24);
        bytes[5] = (byte)(0xFFL & value >> 16);
        bytes[6] = (byte)(0xFFL & value >> 8);
        bytes[7] = (byte)(0xFFL & value);
    }

    public static void convertLong(long value, byte[] bytes, int start) {
        bytes[start] = (byte)(0xFFL & value >> 56);
        bytes[start + 1] = (byte)(0xFFL & value >> 48);
        bytes[start + 2] = (byte)(0xFFL & value >> 40);
        bytes[start + 3] = (byte)(0xFFL & value >> 32);
        bytes[start + 4] = (byte)(0xFFL & value >> 24);
        bytes[start + 5] = (byte)(0xFFL & value >> 16);
        bytes[start + 6] = (byte)(0xFFL & value >> 8);
        bytes[start + 7] = (byte)(0xFFL & value);
    }

    public static void convertChar(char value, byte[] bytes) {
        bytes[0] = (byte)(0xFF & value >> 8);
        bytes[1] = (byte)(0xFF & value);
    }

    public static void convertChar(char value, byte[] bytes, int start) {
        bytes[start] = (byte)(0xFF & value >> 8);
        bytes[start + 1] = (byte)(0xFF & value);
    }

    public static char toChar(byte[] bytes) {
        return (char)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    public static char toChar(byte[] bytes, int start) {
        return (char)(bytes[start] << 8 | bytes[start + 1] & 0xFF);
    }

    public static short toShort(byte[] bytes, int start) {
        return (short)(bytes[start] << 8 | bytes[start + 1] & 0xFF);
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int toInt(byte[] bytes, int start) {
        return (bytes[start] & 0xFF) << 24 | (bytes[start + 1] & 0xFF) << 16 | (bytes[start + 2] & 0xFF) << 8 | bytes[start + 3] & 0xFF;
    }

    public static long toLong(byte[] bytes) {
        return (long)(bytes[0] & 0xFF) << 56 | (long)(bytes[1] & 0xFF) << 48 | (long)(bytes[2] & 0xFF) << 40 | (long)(bytes[3] & 0xFF) << 32 | (long)(bytes[4] & 0xFF) << 24 | (long)(bytes[5] & 0xFF) << 16 | (long)(bytes[6] & 0xFF) << 8 | (long)(bytes[7] & 0xFF);
    }

    public static long toLong(byte[] bytes, int start) {
        return (long)(bytes[start] & 0xFF) << 56 | (long)(bytes[start + 1] & 0xFF) << 48 | (long)(bytes[start + 2] & 0xFF) << 40 | (long)(bytes[start + 3] & 0xFF) << 32 | (long)(bytes[start + 4] & 0xFF) << 24 | (long)(bytes[start + 5] & 0xFF) << 16 | (long)(bytes[start + 6] & 0xFF) << 8 | (long)(bytes[start + 7] & 0xFF);
    }

    private static class IntegerList
    extends AbstractList<Integer>
    implements RandomAccess {
        private final Integer[] array;

        private IntegerList(Integer[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }
    }

    private static class PrimIntegerList
    extends AbstractList<Integer>
    implements RandomAccess {
        private final int[] array;

        private PrimIntegerList(int[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }
    }
}

