/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.text.ParseException;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;

public final class DegreSexagesimal {
    private final boolean positif;
    private final int degre;
    private final int minute;
    private final int seconde;

    private DegreSexagesimal(boolean positif, int degre, int minute, int seconde) {
        this.positif = positif;
        this.degre = degre;
        this.minute = minute;
        this.seconde = seconde;
    }

    public int getDegre() {
        return this.degre;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSeconde() {
        return this.seconde;
    }

    public boolean isPositif() {
        return this.positif;
    }

    public static DegreSexagesimal fromDegreDecimal(DegreDecimal degreDecimal) {
        int min;
        float f = Decimal.toFloat(degreDecimal.getZeroLength(), degreDecimal.getPartieDecimale());
        float minF = f * 60.0f;
        float secF = (minF - (float)(min = (int)Math.floor(minF))) * 60.0f;
        int sec = Math.round(secF);
        if (sec == 60) {
            sec = 0;
            if (++min == 60) {
                min = 59;
                sec = 59;
            }
        }
        return new DegreSexagesimal(degreDecimal.isPositif(), Math.abs(degreDecimal.getPartieEntiere()), min, sec);
    }

    public String toString() {
        return this.toString(true, "");
    }

    public String toString(boolean withSign, String separator) {
        StringBuilder buf = new StringBuilder();
        if (withSign && !this.positif) {
            buf.append("-");
        }
        buf.append(this.degre);
        buf.append('\u00b0');
        buf.append(separator);
        if (this.minute < 10) {
            buf.append('0');
        }
        buf.append(this.minute);
        buf.append('\u2032');
        buf.append(separator);
        if (this.seconde < 10) {
            buf.append('0');
        }
        buf.append(this.seconde);
        buf.append('\u2033');
        return buf.toString();
    }

    public DegreSexagesimal getOppose() {
        if (this.minute == 0 && this.seconde == 0 && (this.degre == 0 || this.degre == 180)) {
            return this;
        }
        return new DegreSexagesimal(!this.positif, this.degre, this.minute, this.seconde);
    }

    public static DegreSexagesimal parse(String s) throws ParseException {
        int integer;
        int i;
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new ParseException("empty", 0);
        }
        char carac = s.charAt(0);
        boolean positif = true;
        if (carac == '-') {
            positif = false;
            length = (s = s.substring(1).trim()).length();
            if (length == 0) {
                throw new ParseException("no digit", 0);
            }
        }
        int degre = 0;
        int minute = 0;
        int seconde = 0;
        int nextIndex = 0;
        boolean valide = false;
        boolean debut = true;
        for (i = 0; i < length; ++i) {
            nextIndex = i + 1;
            integer = DegreSexagesimal.toInt(s.charAt(i));
            if (integer == -2) continue;
            if (integer == -1) {
                if (valide) break;
                throw new ParseException("no digit", 0);
            }
            valide = true;
            if (debut) {
                if (integer == 0) continue;
                debut = false;
            }
            degre = degre * 10 + integer;
        }
        if (nextIndex < length) {
            for (i = nextIndex; i < length && DegreSexagesimal.toInt(s.charAt(i)) < 0; ++i) {
                nextIndex = i + 1;
            }
        }
        if (nextIndex < length) {
            debut = true;
            for (i = nextIndex; i < length; ++i) {
                nextIndex = i + 1;
                integer = DegreSexagesimal.toInt(s.charAt(i));
                if (integer == -2) continue;
                if (integer == -1) break;
                if (debut) {
                    if (integer == 0) continue;
                    debut = false;
                }
                minute = minute * 10 + integer;
            }
        }
        if (nextIndex < length) {
            for (i = nextIndex; i < length && DegreSexagesimal.toInt(s.charAt(i)) < 0; ++i) {
                nextIndex = i + 1;
            }
        }
        if (nextIndex < length) {
            debut = true;
            for (i = nextIndex; i < length; ++i) {
                nextIndex = i + 1;
                integer = DegreSexagesimal.toInt(s.charAt(i));
                if (integer == -2) continue;
                if (integer == -1) break;
                if (debut) {
                    if (integer == 0) continue;
                    debut = false;
                }
                seconde = seconde * 10 + integer;
            }
        }
        int modulo = seconde / 60;
        seconde -= 60 * modulo;
        minute += modulo;
        modulo = minute / 60;
        degre += modulo;
        if ((degre %= 360) > 180 || degre == 180 & (!positif || (minute -= 60 * modulo) == 0 && seconde == 0)) {
            minute = 60 - minute;
            seconde = 60 - seconde;
            degre = 180;
            positif = !positif;
        }
        return new DegreSexagesimal(positif, degre, minute, seconde);
    }

    private static int toInt(char carac) {
        if (carac == ' ') {
            return -2;
        }
        if (carac < '0' || carac > '9') {
            return -1;
        }
        return carac - 48;
    }
}

