/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.io.Serializable;
import java.math.BigDecimal;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreSexagesimal;

public final class DegreDecimal
implements Serializable,
Comparable<DegreDecimal> {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal moins360 = new BigDecimal(-360);
    private static final BigDecimal plus360 = new BigDecimal(360);
    private final int partieEntiere;
    private final int partieDecimale;
    private final byte zeroLength;

    private DegreDecimal(DecimalChecker decimalChecker) {
        this.partieEntiere = decimalChecker.partieEntiere;
        this.zeroLength = decimalChecker.zeroLength;
        this.partieDecimale = decimalChecker.partieDecimale;
    }

    private DegreDecimal(DegreSexagesimal degreSexagesimal) {
        int degre = degreSexagesimal.getDegre();
        int seconde = degreSexagesimal.getMinute() * 60 + degreSexagesimal.getSeconde();
        int mm = Math.round((float)seconde * 2500.0f / 9.0f);
        if (mm == 0) {
            this.zeroLength = (byte)6;
        } else {
            String s = String.valueOf(mm);
            this.zeroLength = (byte)(6 - s.length());
        }
        if (degreSexagesimal.isPositif()) {
            this.partieEntiere = -degre;
            this.partieDecimale = -mm;
        } else {
            this.partieEntiere = degre;
            this.partieDecimale = mm;
        }
    }

    public boolean isPositif() {
        return this.partieEntiere >= 0 && this.partieDecimale >= 0;
    }

    public double toDouble() {
        return Double.parseDouble(this.toString());
    }

    public float toFloat() {
        return Float.parseFloat(this.toString());
    }

    public Decimal toDecimal() {
        return new Decimal(this.partieEntiere, this.zeroLength, this.partieDecimale);
    }

    public double toRadians() {
        return Math.toRadians(Double.parseDouble(this.toString()));
    }

    public String toString() {
        return Decimal.toString(this.partieEntiere, this.zeroLength, this.partieDecimale);
    }

    public int getPartieEntiere() {
        return this.partieEntiere;
    }

    public int getPartieDecimale() {
        return this.partieDecimale;
    }

    public byte getZeroLength() {
        return this.zeroLength;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DegreDecimal other = (DegreDecimal)obj;
        if (other.partieEntiere != this.partieEntiere) {
            return false;
        }
        if (other.partieDecimale != this.partieDecimale) {
            return false;
        }
        return other.zeroLength == this.zeroLength;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(DegreDecimal other) {
        int pE = this.partieEntiere;
        if (pE < other.partieEntiere) {
            return -1;
        }
        if (pE > other.partieEntiere) {
            return 1;
        }
        if (pE < 0) {
            return -DegreDecimal.comparePartieDecimale(this.zeroLength, this.partieDecimale, other.zeroLength, other.partieDecimale);
        }
        return DegreDecimal.comparePartieDecimale(this.zeroLength, this.partieDecimale, other.zeroLength, other.partieDecimale);
    }

    public DegreSexagesimal toDegreSexagesimal() {
        return DegreSexagesimal.fromDegreDecimal(this);
    }

    public static DegreDecimal newInstance(int partieEntiere, byte zeroLength, int partieDecimale) {
        if (partieEntiere < 0) {
            if (partieDecimale > 0) {
                partieDecimale = -partieDecimale;
            }
        } else if (partieEntiere > 0 && partieDecimale < 0) {
            partieDecimale = -partieDecimale;
        }
        if (zeroLength < 0) {
            zeroLength = -zeroLength;
        }
        DecimalChecker checker = new DecimalChecker(DegreDecimal.modulo(partieEntiere), zeroLength, partieDecimale);
        checker.check();
        return new DegreDecimal(checker);
    }

    public static DegreDecimal newInstance(Decimal decimal) {
        DecimalChecker checker = new DecimalChecker(DegreDecimal.modulo(decimal.getPartieEntiere()), decimal.getZeroLength(), decimal.getPartieDecimale());
        checker.check();
        return new DegreDecimal(checker);
    }

    public static DegreDecimal newInstance(DegreSexagesimal degreSexagesimal) {
        return new DegreDecimal(degreSexagesimal);
    }

    private static int modulo(long partieEntiere) {
        long modulo = partieEntiere / 360L;
        int result = (int)(partieEntiere - modulo * 360L);
        return result;
    }

    private static int comparePartieDecimale(byte zeroLength1, int decimal1, byte zeroLength2, int decimal2) {
        String string2;
        if (zeroLength1 > zeroLength2) {
            return -1;
        }
        if (zeroLength1 < zeroLength2) {
            return 1;
        }
        if (decimal1 == decimal2) {
            return 0;
        }
        String string1 = Integer.toString(Math.abs(decimal1));
        int comp = string1.compareTo(string2 = Integer.toString(Math.abs(decimal2)));
        if (comp < 0) {
            return -1;
        }
        if (comp > 0) {
            return 1;
        }
        return 0;
    }

    private static class DecimalChecker {
        private int partieEntiere;
        private int partieDecimale;
        private byte zeroLength;

        DecimalChecker(int partieEntiere, byte zeroLength, int partieDecimale) {
            this.partieEntiere = partieEntiere;
            this.zeroLength = zeroLength;
            this.partieDecimale = partieDecimale;
        }

        private void check() {
            this.checkDecimale();
            this.checkDegre();
        }

        private void checkDegre() {
            if (Math.abs(this.partieEntiere) < 180) {
                return;
            }
            if (this.partieEntiere == 180 && this.partieDecimale == 0) {
                return;
            }
            BigDecimal bigDecimal = new Decimal(this.partieEntiere, this.zeroLength, this.partieDecimale).toBigDecimal();
            bigDecimal = this.partieEntiere > 180 ? bigDecimal.add(moins360) : bigDecimal.add(plus360);
            Decimal newDecimal = Decimal.fromBigDecimal(bigDecimal);
            this.partieEntiere = (int)newDecimal.getPartieEntiere();
            this.partieDecimale = newDecimal.getPartieDecimale();
            this.zeroLength = newDecimal.getZeroLength();
        }

        private void checkDecimale() {
            boolean negatif;
            if (this.partieDecimale == 0) {
                this.zeroLength = 0;
                return;
            }
            if (this.zeroLength > 6) {
                this.zeroLength = 0;
                this.partieDecimale = 0;
            }
            int dec = Math.abs(this.partieDecimale);
            boolean bl = negatif = this.partieDecimale < 0;
            while (dec % 10 == 0) {
                dec /= 10;
            }
            String s = String.valueOf(dec);
            if (this.zeroLength == 6) {
                if (s.charAt(0) > '5') {
                    this.zeroLength = (byte)5;
                    this.partieDecimale = negatif ? -1 : 1;
                } else {
                    this.zeroLength = 0;
                    this.partieDecimale = 0;
                }
                return;
            }
            int p = 6 - this.zeroLength;
            if (s.length() <= p) {
                return;
            }
            dec = Integer.parseInt(s.substring(0, p));
            if (s.charAt(p) > '5') {
                boolean neufS = true;
                for (int i = 0; i < p; ++i) {
                    if (s.charAt(i) == '9') continue;
                    neufS = false;
                }
                if (!neufS) {
                    ++dec;
                } else if (this.zeroLength > 0) {
                    this.zeroLength = (byte)(this.zeroLength - 1);
                    dec = 1;
                } else {
                    dec = 0;
                    this.partieEntiere = this.partieEntiere > 0 ? ++this.partieEntiere : (this.partieEntiere < 0 ? --this.partieEntiere : (negatif ? -1 : 1));
                }
            }
            this.partieDecimale = negatif ? -dec : dec;
        }
    }
}

