/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.models;

public interface EmailCore {
    public String getAddrSpec();

    public String getRealName();

    default public String getComputedRealName() {
        return this.getRealName();
    }

    default public String toCompleteString() {
        return this.toCompleteString(false);
    }

    default public String toCompleteString(boolean computed) {
        String realName = computed ? this.getComputedRealName() : this.getRealName();
        String addrSpec = this.getAddrSpec();
        if (realName.length() == 0) {
            return addrSpec;
        }
        StringBuilder buf = new StringBuilder();
        boolean needQuotes = false;
        boolean whitespace = false;
        for (int i = 0; i < realName.length(); ++i) {
            char carac = realName.charAt(i);
            if (Character.isWhitespace(carac)) {
                whitespace = true;
            }
            if (Character.isISOControl(carac)) continue;
            if (whitespace) {
                whitespace = false;
                buf.append(' ');
            }
            if (carac == '\"' || carac == '\\') {
                needQuotes = true;
                buf.append('\\');
            } else if (carac == '>' || carac == '<') {
                needQuotes = true;
            }
            buf.append(carac);
        }
        if (needQuotes) {
            buf.insert(0, '\"');
            buf.append('\"');
        }
        buf.append(" <");
        buf.append(addrSpec);
        buf.append(">");
        return buf.toString();
    }
}

