/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.logging.LineLog;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.LogUtils;

public class LineLogsBuilder
implements LineMessageHandler {
    private final SortedMap<Integer, LineLogBuilder> lineLogBuilderMap = new TreeMap<Integer, LineLogBuilder>();

    @Override
    public void addMessage(LineMessage message) {
        int lineNumber = message.getLineNumber();
        LineLogBuilder lineLogBuilder = (LineLogBuilder)this.lineLogBuilderMap.get(lineNumber);
        if (lineLogBuilder == null) {
            lineLogBuilder = new LineLogBuilder(lineNumber);
            this.lineLogBuilderMap.put(lineNumber, lineLogBuilder);
        }
        lineLogBuilder.add(message);
    }

    public boolean hasMessage() {
        return !this.lineLogBuilderMap.isEmpty();
    }

    public LineLogs toLineLogs() {
        int size = this.lineLogBuilderMap.size();
        LineLog[] array = new LineLog[size];
        int p = 0;
        for (LineLogBuilder lineLogBuilder : this.lineLogBuilderMap.values()) {
            array[p] = lineLogBuilder.toLineLog();
            ++p;
        }
        return new InternalLineLogs(array);
    }

    public List<LineMessage> toLineMessageList() {
        ArrayList<LineMessage> result = new ArrayList<LineMessage>();
        for (LineLogBuilder lineLogBuilder : this.lineLogBuilderMap.values()) {
            result.addAll(lineLogBuilder.messageList);
        }
        return result;
    }

    public static LineLogsBuilder init() {
        return new LineLogsBuilder();
    }

    private static class LineLogBuilder {
        private final int lineNumber;
        private final List<LineMessage> messageList = new ArrayList<LineMessage>();

        private LineLogBuilder(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        private void add(LineMessage message) {
            this.messageList.add(message);
        }

        private LineLog toLineLog() {
            List<LineMessage> finalMessageList = LogUtils.wrap(this.messageList.toArray(new LineMessage[this.messageList.size()]));
            return new InternalLineLog(this.lineNumber, finalMessageList);
        }
    }

    private static class InternalLineLogs
    extends AbstractList<LineLog>
    implements LineLogs {
        private final LineLog[] array;

        private InternalLineLogs(LineLog[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public LineLog get(int i) {
            return this.array[i];
        }
    }

    private static class InternalLineLog
    implements LineLog {
        private final int lineNumber;
        private final List<LineMessage> messageList;

        private InternalLineLog(int lineNumber, List<LineMessage> messageList) {
            this.lineNumber = lineNumber;
            this.messageList = messageList;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public List<LineMessage> getLineMessageList() {
            return this.messageList;
        }
    }
}

