/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.SourceMessage;

public final class LocalisationUtils {
    public static final List<Message> EMPTY_MESSAGELIST = Collections.emptyList();
    public static final List<SourceMessage> EMPTY_SOURCEMESSAGELIST = Collections.emptyList();
    public static final UserLangContext DEFAULT_LANGCONTEXT = LocalisationUtils.toUserLangContext(Lang.getDefault());
    private static final Set<String> EMPTY_SET = Collections.emptySet();
    private static final Object[] EMPTY = new Object[0];
    private static final Lang FRENCH = Lang.build("fr");
    private static final Map<Lang, String> langVoMap;

    private LocalisationUtils() {
    }

    public static String getKibiOctet(Locale locale) {
        String language = locale.getLanguage();
        if (language.equals("fr")) {
            return "Kio";
        }
        return "KiB";
    }

    public static String getKibiOctet(Lang lang) {
        Lang rootLang = lang.getRootLang();
        if (rootLang.equals(FRENCH)) {
            return "Kio";
        }
        return "KiB";
    }

    public static String getMebiOctet(Locale locale) {
        String language = locale.getLanguage();
        if (language.equals("fr")) {
            return "Mio";
        }
        return "MiB";
    }

    public static String getMebiOctet(Lang lang) {
        Lang rootLang = lang.getRootLang();
        if (rootLang.equals(FRENCH)) {
            return "Mio";
        }
        return "MiB";
    }

    public static String getVOTitle(Lang lang) {
        return langVoMap.get(lang);
    }

    public static Message toMessage(String messageKey) {
        if (messageKey == null) {
            throw new IllegalArgumentException("messageKey is null");
        }
        return new InternalMessage(messageKey, EMPTY);
    }

    public static Message toMessage(String messageKey, Object ... messageValues) {
        if (messageKey == null) {
            throw new IllegalArgumentException("messageKey is null");
        }
        if (messageValues == null) {
            messageValues = EMPTY;
        }
        return new InternalMessage(messageKey, messageValues);
    }

    public static String cleanMessageKey(String messageKey) {
        if (messageKey.startsWith("_ ")) {
            messageKey = messageKey.substring(2);
        }
        return messageKey;
    }

    public static Locale getDefaultFormatLocale(LangContext langContext) {
        if (langContext instanceof ListLangContext) {
            return ((ListLangContext.Unit)((ListLangContext)langContext).get(0)).getFormatLocale();
        }
        if (langContext instanceof UserLangContext) {
            return ((UserLangContext)langContext).getFormatLocale();
        }
        return Locale.getDefault();
    }

    public static UserLangContext toUserLangContext(Lang workingLang) {
        return new SimpleUserLangContext(workingLang);
    }

    public static UserLangContext toUserLangContext(Lang workingLang, @Nullable Locale locale) {
        if (locale == null) {
            return new SimpleUserLangContext(workingLang);
        }
        return new InternalUserLangContext(workingLang, locale, null);
    }

    public static UserLangContext toUserLangContext(Lang workingLang, Locale formatLocale, LangPreference langPreference) {
        if (formatLocale == null && langPreference == null) {
            return new SimpleUserLangContext(workingLang);
        }
        return new InternalUserLangContext(workingLang, formatLocale, langPreference);
    }

    public static Set<String> scanMessageKeys(String text) {
        try {
            return LocalisationUtils.scanMessageKeys(new BufferedReader(new StringReader(text)));
        }
        catch (IOException ioe) {
            return EMPTY_SET;
        }
    }

    public static Set<String> scanMessageKeys(InputStream inputStream, String charset) throws IOException {
        return LocalisationUtils.scanMessageKeys(new BufferedReader(new InputStreamReader(inputStream, charset)));
    }

    public static List<Message> wrap(Message[] array) {
        return new MessageList(array);
    }

    public static LangPreference toLangPreference(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("lang is null");
        }
        return new UniqueLangPreference(lang);
    }

    public static String joinValues(Object ... messageValues) {
        if (messageValues == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Object value : messageValues) {
            if (value == null) continue;
            buf.append(value.toString());
        }
        return buf.toString();
    }

    public static String joinValues(Message message) {
        return LocalisationUtils.joinValues(message.getMessageValues());
    }

    private static Set<String> scanMessageKeys(BufferedReader reader) throws IOException {
        String line;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        while ((line = reader.readLine()) != null) {
            LocalisationUtils.checkLine(line, set);
        }
        if (set.isEmpty()) {
            return EMPTY_SET;
        }
        return set;
    }

    private static void checkLine(String line, Set<String> set) {
        String key;
        int idx2;
        int idx = line.indexOf("\"_ ");
        while (idx != -1 && (idx2 = line.indexOf("\"", idx + 3)) != -1) {
            key = line.substring(idx + 1, idx2);
            set.add(key);
            idx = line.indexOf("\"_ ", idx2 + 1);
        }
        idx = line.indexOf("'_ ");
        while (idx != -1 && (idx2 = line.indexOf("'", idx + 3)) != -1) {
            key = line.substring(idx + 1, idx2);
            set.add(key);
            idx = line.indexOf("'_ ", idx2 + 1);
        }
    }

    static {
        try (InputStream is = LocalisationUtils.class.getResourceAsStream("vo_lang.ini");){
            HashMap<String, String> iniMap = new HashMap<String, String>();
            IniParser.parseIni(is, iniMap);
            langVoMap = new HashMap<Lang, String>();
            for (Map.Entry entry : iniMap.entrySet()) {
                try {
                    Lang lang = Lang.parse((String)entry.getKey());
                    langVoMap.put(lang, (String)entry.getValue());
                }
                catch (ParseException parseException) {}
            }
        }
        catch (IOException ioe) {
            throw new InternalResourceException(ioe);
        }
    }

    private static class InternalMessage
    implements Message {
        private final String messageKey;
        private final Object[] messageValues;

        private InternalMessage(String messageKey, Object[] messageValues) {
            this.messageKey = messageKey;
            this.messageValues = messageValues;
        }

        @Override
        public String getMessageKey() {
            return this.messageKey;
        }

        @Override
        public Object[] getMessageValues() {
            return this.messageValues;
        }
    }

    private static class SimpleUserLangContext
    implements UserLangContext {
        private final Lang workingLang;
        private final LangPreference langPreference;
        private final Locale formatLocale;

        private SimpleUserLangContext(Lang workingLang) {
            this.workingLang = workingLang;
            this.langPreference = LocalisationUtils.toLangPreference(workingLang);
            this.formatLocale = workingLang.toLocale();
        }

        @Override
        public Lang getWorkingLang() {
            return this.workingLang;
        }

        @Override
        public LangPreference getLangPreference() {
            return this.langPreference;
        }

        @Override
        public Locale getFormatLocale() {
            return this.formatLocale;
        }

        @Override
        public boolean isDefaultLocale() {
            return true;
        }

        @Override
        public boolean isDefaultLangPreference() {
            return true;
        }
    }

    private static class InternalUserLangContext
    implements UserLangContext {
        private final Lang workingLang;
        private final LangPreference langPreference;
        private final Locale formatLocale;

        private InternalUserLangContext(Lang workingLang, Locale formatLocale, LangPreference langPreference) {
            this.workingLang = workingLang;
            this.langPreference = langPreference == null ? LocalisationUtils.toLangPreference(workingLang) : langPreference;
            this.formatLocale = formatLocale == null ? workingLang.toLocale() : formatLocale;
        }

        @Override
        public Lang getWorkingLang() {
            return this.workingLang;
        }

        @Override
        public LangPreference getLangPreference() {
            return this.langPreference;
        }

        @Override
        public Locale getFormatLocale() {
            return this.formatLocale;
        }
    }

    private static class MessageList
    extends AbstractList<Message>
    implements RandomAccess {
        private final Message[] array;

        private MessageList(Message[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Message get(int index) {
            return this.array[index];
        }
    }

    private static class UniqueLangPreference
    extends AbstractList<Lang>
    implements LangPreference {
        private final Lang lang;

        private UniqueLangPreference(Lang lang) {
            this.lang = lang;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Lang get(int index) {
            if (index == 0) {
                return this.lang;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Lang getFirstLang() {
            return this.lang;
        }
    }
}

