/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public final class LangScript
implements Serializable,
Comparable<LangScript> {
    private static final long serialVersionUID = 1L;
    private static final Map<String, LangScript> langScriptMap = new HashMap<String, LangScript>();
    private final String code;

    private LangScript(String code) {
        this.code = code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        LangScript otherLangScript = (LangScript)other;
        return otherLangScript.code.equals(this.code);
    }

    public String toString() {
        return this.code;
    }

    @Override
    public int compareTo(LangScript otherLangScript) {
        return this.code.compareTo(otherLangScript.code);
    }

    public boolean isRTLScript() {
        if (this.code.equals("Arab")) {
            return true;
        }
        if (this.code.equals("Aran")) {
            return true;
        }
        return this.code.equals("Hebr");
    }

    public static LangScript build(String langScriptCode) {
        try {
            return LangScript.parse(langScriptCode);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static LangScript parse(String langScriptCode) throws ParseException {
        if (langScriptCode == null) {
            throw new ParseException("null", 0);
        }
        LangScript langScript = langScriptMap.get(langScriptCode);
        if (langScript != null) {
            return langScript;
        }
        Map<String, LangScript> map = langScriptMap;
        synchronized (map) {
            int length = langScriptCode.length();
            if (length == 4) {
                langScript = langScriptMap.get(langScriptCode = LangScript.normalize(langScriptCode));
                if (langScript != null) {
                    return langScript;
                }
                if (!LangScript.testUpperCase(langScriptCode.charAt(0))) {
                    throw new ParseException("wrong char: " + langScriptCode.charAt(0), 0);
                }
                if (!LangScript.testLowerCase(langScriptCode.charAt(1))) {
                    throw new ParseException("wrong char: " + langScriptCode.charAt(1), 1);
                }
                if (!LangScript.testLowerCase(langScriptCode.charAt(2))) {
                    throw new ParseException("wrong char: " + langScriptCode.charAt(2), 2);
                }
                if (!LangScript.testLowerCase(langScriptCode.charAt(3))) {
                    throw new ParseException("wrong char: " + langScriptCode.charAt(3), 3);
                }
                langScript = new LangScript(langScriptCode);
                langScriptMap.put(langScriptCode, langScript);
                return langScript;
            }
            if (length == 0) {
                throw new ParseException("empty", 0);
            }
            if (length < 4) {
                throw new ParseException("length < 4", 0);
            }
            throw new ParseException("length > 2", 2);
        }
    }

    private static String normalize(String langScriptCode) {
        StringBuilder buf = new StringBuilder();
        buf.append(Character.toUpperCase(langScriptCode.charAt(0)));
        for (int i = 1; i < 4; ++i) {
            buf.append(Character.toLowerCase(langScriptCode.charAt(i)));
        }
        return buf.toString();
    }

    private static boolean testUpperCase(char carac) {
        return carac >= 'A' && carac <= 'Z';
    }

    private static boolean testLowerCase(char carac) {
        return carac >= 'a' && carac <= 'z';
    }
}

