/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.jslib;

import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.text.RelativePath;

public class TemplateFamilyBuilder {
    private final String name;
    private RelativePath path = null;

    public TemplateFamilyBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public TemplateFamilyBuilder setPath(RelativePath path) {
        this.path = path;
        return this;
    }

    public TemplateFamily toTemplateFamily() {
        RelativePath finalPath = this.path;
        if (finalPath == null) {
            finalPath = RelativePath.build("templates/" + this.name);
        }
        return new InternalTemplateFamily(this.name, finalPath);
    }

    public static TemplateFamilyBuilder init(String name) {
        return new TemplateFamilyBuilder(name);
    }

    public static TemplateFamilyBuilder init(String name, RelativePath path) {
        return new TemplateFamilyBuilder(name);
    }

    private static class InternalTemplateFamily
    implements TemplateFamily {
        private final String name;
        private final RelativePath path;

        private InternalTemplateFamily(String name, RelativePath path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public RelativePath getPath() {
            return this.path;
        }
    }
}

