/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.text.RelativePath;

public interface ResourceStorages
extends List<ResourceStorage>,
RandomAccess {
    @Nullable
    public ResourceStorage getResourceStorage(String var1);

    default public boolean containsResource(RelativePath path) {
        for (ResourceStorage resourceStorage : this) {
            boolean here = resourceStorage.containsResource(path);
            if (!here) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public DocStream getResourceDocStream(RelativePath path, MimeTypeResolver mimeTypeResolver) {
        String storageName;
        ResourceStorage resourceStorage;
        int idx;
        String fileName = path.getLastName();
        if (fileName.startsWith("_") && (idx = fileName.indexOf(95, 1)) != -1 && (resourceStorage = this.getResourceStorage(storageName = fileName.substring(1, idx))) != null) {
            path = RelativePath.build(path.getParentPath() + fileName.substring(idx + 1));
            return resourceStorage.getResourceDocStream(path, mimeTypeResolver);
        }
        for (ResourceStorage resourceStorage2 : this) {
            DocStream docStream = resourceStorage2.getResourceDocStream(path, mimeTypeResolver);
            if (docStream == null) continue;
            return docStream;
        }
        return null;
    }

    @Nullable
    default public DocStream getResourceDocStream(RelativePath path) {
        return this.getResourceDocStream(path, MimeTypeUtils.DEFAULT_RESOLVER);
    }

    default public SortedMap<String, RelativePath> listResources(RelativePath relativePath, boolean recursive) {
        TreeMap<String, RelativePath> map = new TreeMap<String, RelativePath>();
        for (ResourceStorage resourceStorage : this) {
            ResourceFolder folder = resourceStorage.getResourceFolder(relativePath);
            if (folder == null) continue;
            for (String resourceName : folder.getResourceNameList()) {
                map.put(resourceName, relativePath.buildChild(resourceName));
            }
            if (!recursive) continue;
            for (ResourceFolder subfolder : folder.getSubfolderList()) {
                String folderName = subfolder.getName();
                ResourceUtils.addSubressources(map, subfolder, relativePath.buildChild(folderName), folderName + "/");
            }
        }
        return map;
    }

    default public SortedMap<String, RelativePath> listSubFolders(RelativePath relativePath) {
        TreeMap<String, RelativePath> map = new TreeMap<String, RelativePath>();
        for (ResourceStorage resourceStorage : this) {
            ResourceFolder folder = resourceStorage.getResourceFolder(relativePath);
            if (folder == null) continue;
            for (ResourceFolder subfolder : folder.getSubfolderList()) {
                String name = subfolder.getName();
                if (map.containsKey(name)) continue;
                map.put(name, relativePath.buildChild(name));
            }
        }
        return map;
    }
}

