/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.text.StringUtils;

public class ResourceFolderBuilder {
    private final String name;
    private final SortedMap<String, ResourceFolderBuilder> builderMap = new TreeMap<String, ResourceFolderBuilder>();
    private final SortedSet<String> resourceSet = new TreeSet<String>();

    public ResourceFolderBuilder(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }

    public void addResource(String resourceName) {
        if (!this.builderMap.containsKey(resourceName)) {
            this.resourceSet.add(resourceName);
        }
    }

    public ResourceFolderBuilder getSubfolderBuilder(String name) {
        ResourceFolderBuilder subfolderBuilder = (ResourceFolderBuilder)this.builderMap.get(name);
        if (subfolderBuilder == null) {
            subfolderBuilder = new ResourceFolderBuilder(name);
            this.builderMap.put(name, subfolderBuilder);
        }
        this.resourceSet.remove(name);
        return subfolderBuilder;
    }

    public ResourceFolder toRessourceFolder() {
        ArrayList<ResourceFolder> list = new ArrayList<ResourceFolder>();
        for (ResourceFolderBuilder builder : this.builderMap.values()) {
            list.add(builder.toRessourceFolder());
        }
        return ResourceFolderBuilder.build(this.name, list, this.resourceSet);
    }

    public static ResourceFolderBuilder init(String name) {
        return new ResourceFolderBuilder(name);
    }

    public static ResourceFolder build(String name, Collection<ResourceFolder> subfolders, Collection<String> resourceNames) {
        List<ResourceFolder> subnodeList = ResourceUtils.wrap(subfolders.toArray(new ResourceFolder[subfolders.size()]));
        List<String> resourceNameList = StringUtils.toList(resourceNames);
        return new InternalResourceFolder(name, subnodeList, resourceNameList);
    }

    private static class InternalResourceFolder
    implements ResourceFolder {
        private final String name;
        private final List<ResourceFolder> subnodeList;
        private final List<String> resourceNameList;

        private InternalResourceFolder(String name, List<ResourceFolder> subnodeList, List<String> resourceNameList) {
            this.name = name;
            this.subnodeList = subnodeList;
            this.resourceNameList = resourceNameList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<ResourceFolder> getSubfolderList() {
            return this.subnodeList;
        }

        @Override
        public List<String> getResourceNameList() {
            return this.resourceNameList;
        }
    }
}

