/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.mapeadores.util.exceptions.ExceptionsUtils;
import org.xml.sax.SAXParseException;

public class BufferErrorListener
implements ErrorListener {
    private final List<TransformerException> errorList = new ArrayList<TransformerException>();
    private final List<TransformerException> warningList = new ArrayList<TransformerException>();
    private final Set<String> messageSet = new HashSet<String>();

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public boolean hasWarning() {
        return !this.warningList.isEmpty();
    }

    public String getErrorMessage() {
        StringBuilder buf = new StringBuilder();
        for (TransformerException te : this.errorList) {
            if (buf.length() > 0) {
                buf.append(" / ");
            }
            buf.append(this.getTransformerMessage(te));
        }
        return buf.toString();
    }

    public String getWarningMessage() {
        StringBuilder buf = new StringBuilder();
        for (TransformerException te : this.warningList) {
            if (buf.length() > 0) {
                buf.append(" / ");
            }
            buf.append(this.getTransformerMessage(te));
        }
        return buf.toString();
    }

    public List<TransformerException> getErrorList() {
        return this.errorList;
    }

    public List<TransformerException> getWarningList() {
        return this.warningList;
    }

    @Override
    public void error(TransformerException transformerException) throws TransformerException {
        this.addError(transformerException);
    }

    @Override
    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.addError(transformerException);
        throw transformerException;
    }

    @Override
    public void warning(TransformerException transformerException) throws TransformerException {
        this.addWarning(transformerException);
    }

    public void addError(TransformerException transformerException) {
        String message = transformerException.getMessageAndLocation();
        if (!this.messageSet.contains(message)) {
            this.messageSet.add(message);
            this.errorList.add(transformerException);
        }
    }

    public void addWarning(TransformerException transformerException) {
        String message = transformerException.getMessageAndLocation();
        if (!this.messageSet.contains(message)) {
            this.messageSet.add(message);
            this.warningList.add(transformerException);
        }
    }

    private String getTransformerMessage(TransformerException te) {
        Throwable e = te.getCause();
        if (e != null && e instanceof TransformerException) {
            return this.getTransformerMessage((TransformerException)e);
        }
        StringBuilder buf = new StringBuilder();
        SourceLocator sourceLocator = te.getLocator();
        if (sourceLocator != null) {
            ExceptionsUtils.append(buf, sourceLocator.getPublicId(), sourceLocator.getSystemId(), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
        } else if (e != null && e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            ExceptionsUtils.append(buf, spe);
        }
        if (e != null) {
            buf.append(e.getLocalizedMessage());
        } else {
            buf.append(te.getMessageAndLocation());
        }
        return buf.toString();
    }
}

