/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.instruction;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.mapeadores.util.instruction.Argument;

public interface Instruction
extends List<Argument>,
RandomAccess {
    default public Map<String, Object> toOptionMap(int offset) {
        int size = this.size();
        if (offset >= size) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = offset; i < size; ++i) {
            Object optionValue;
            Argument argument = (Argument)this.get(i);
            String optionName = argument.getKey();
            String value = argument.getNotNullValue();
            if (value.isEmpty()) {
                if (optionName.startsWith("!")) {
                    optionName = optionName.substring(1);
                    optionValue = Boolean.FALSE;
                } else {
                    optionValue = Boolean.TRUE;
                }
            } else {
                try {
                    optionValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    optionValue = value;
                }
            }
            result.put(optionName, optionValue);
        }
        return result;
    }

    default public boolean hasArgument(String key) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Argument argument = (Argument)this.get(i);
            if (!argument.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    default public Argument getArgument(String key) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Argument argument = (Argument)this.get(i);
            if (!argument.getKey().equals(key)) continue;
            return argument;
        }
        return null;
    }

    default public String getArgumentValue(String key) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Argument argument = (Argument)this.get(i);
            if (!argument.getKey().equals(key)) continue;
            return argument.getNotNullValue();
        }
        return null;
    }
}

