/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.email;

import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.smtp.SmtpParameters;
import net.mapeadores.util.smtp.SmtpUtils;

public final class EmailUtils {
    private EmailUtils() {
    }

    public static InternetAddress convert(EmailCore emailCore) {
        String realName = emailCore.getRealName();
        try {
            InternetAddress result = realName.isEmpty() ? new InternetAddress(emailCore.getAddrSpec()) : new InternetAddress(emailCore.getAddrSpec(), realName, "UTF-8");
            return result;
        }
        catch (AddressException ae) {
            throw new ImplementationException((Exception)((Object)ae));
        }
        catch (UnsupportedEncodingException uee) {
            throw new ShouldNotOccurException(uee);
        }
    }

    public static InternetAddress[] convert(Collection<EmailCore> collection) {
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        for (EmailCore emailCore : collection) {
            list.add(EmailUtils.convert(emailCore));
        }
        return list.toArray(new InternetAddress[list.size()]);
    }

    public static Session createSession(final SmtpParameters smtpParameters) {
        Properties properties = System.getProperties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", smtpParameters.getHost());
        properties.put("mail.smtp.port", (Object)smtpParameters.getPort());
        properties.put("mail.smtp.starttls.enable", "true");
        String authentificationType = smtpParameters.getAuthentificationType();
        Authenticator authenticator = null;
        if (SmtpUtils.isUserMandatory(authentificationType)) {
            properties.setProperty("mail.smtp.auth", "true");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(smtpParameters.getUsername(), smtpParameters.getPassword());
                }
            };
            switch (authentificationType) {
                case "ssl": {
                    properties.put("mail.smtp.ssl.enable", "true");
                    break;
                }
                case "starttls": {
                    properties.put("mail.smtp.starttls.required", "true");
                }
            }
        }
        if (authenticator != null) {
            return Session.getInstance((Properties)properties, authenticator);
        }
        return Session.getInstance((Properties)properties);
    }
}

