/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.awt;

public final class ResizeInfo {
    public static final short WIDTH_RESIZING = 1;
    public static final short HEIGHT_RESIZING = 2;
    public static final short BOTH_RESIZING = 3;
    private final short type;
    private int width = 0;
    private int height = 0;
    private boolean max = false;

    private ResizeInfo(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isOnlyMax() {
        return this.max;
    }

    public Check checkDim(int dimWidth, int dimHeight) {
        int resultWidth = dimWidth;
        int resultHeight = dimHeight;
        float ratio = 1.0f;
        if (this.type == 1) {
            if (!(dimWidth == this.width || this.max && dimWidth <= this.width)) {
                resultWidth = this.width;
                ratio = (float)this.width / (float)dimWidth;
                resultHeight = (int)(ratio * (float)dimHeight);
            }
        } else if (this.type == 2) {
            if (!(dimHeight == this.height || this.max && dimHeight <= this.height)) {
                resultHeight = this.height;
                ratio = (float)this.height / (float)dimHeight;
                resultWidth = (int)(ratio * (float)dimWidth);
            }
        } else if (this.type == 3) {
            resultWidth = this.width;
            resultHeight = this.height;
            if (this.max) {
                float widthRatio = (float)this.width / (float)dimWidth;
                float heightRatio = (float)this.height / (float)dimHeight;
                if (widthRatio < heightRatio) {
                    ratio = widthRatio;
                    resultHeight = (int)(ratio * (float)this.height);
                } else {
                    ratio = heightRatio;
                    resultWidth = (int)(ratio * (float)this.width);
                }
            } else {
                ratio = Math.max((float)this.width / (float)dimWidth, (float)this.height / (float)dimHeight);
            }
        }
        return new Check(resultWidth, resultHeight, ratio);
    }

    public int hashCode() {
        return this.type + this.height + this.width;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        ResizeInfo otherResizeInfo = (ResizeInfo)other;
        if (otherResizeInfo.type != this.type) {
            return false;
        }
        if (otherResizeInfo.width != this.width) {
            return false;
        }
        if (otherResizeInfo.height != this.height) {
            return false;
        }
        return otherResizeInfo.max == this.max;
    }

    public static ResizeInfo newFixedWidthInstance(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("width < 1");
        }
        ResizeInfo obj = new ResizeInfo(1);
        obj.width = width;
        obj.max = false;
        return obj;
    }

    public static ResizeInfo newFixedHeightInstance(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("width < 1");
        }
        ResizeInfo obj = new ResizeInfo(2);
        obj.height = height;
        obj.max = false;
        return obj;
    }

    public static ResizeInfo newFixedDimInstance(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("width < 1");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height < 1");
        }
        ResizeInfo obj = new ResizeInfo(3);
        obj.width = width;
        obj.height = height;
        obj.max = false;
        return obj;
    }

    public static ResizeInfo newMaxWidthInstance(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("width < 1");
        }
        ResizeInfo obj = new ResizeInfo(1);
        obj.width = width;
        obj.max = true;
        return obj;
    }

    public static ResizeInfo newMaxHeightInstance(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("height < 1");
        }
        ResizeInfo obj = new ResizeInfo(2);
        obj.height = height;
        obj.max = true;
        return obj;
    }

    public static ResizeInfo newMaxDimInstance(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("width < 1");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height < 1");
        }
        ResizeInfo obj = new ResizeInfo(3);
        obj.width = width;
        obj.height = height;
        obj.max = true;
        return obj;
    }

    public static class Check {
        private final int width;
        private final int height;
        private final float ratio;

        private Check(int width, int height, float ratio) {
            this.width = width;
            this.height = height;
            this.ratio = ratio;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getRatio() {
            return this.ratio;
        }
    }
}

