/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.parse;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.elements.OdElement;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class OdCssDocumentHandler
implements DocumentHandler {
    private final ElementMaps elementMaps = new ElementMaps();
    private final List<OdElement> elementList = new ArrayList<OdElement>();
    private final List<String> importList = new ArrayList<String>();

    public List<String> getImportList() {
        return this.importList;
    }

    public void charset(String characterEncoding) throws CSSException {
    }

    public ElementMaps getElementMaps() {
        return this.elementMaps;
    }

    public void startPage(String string, String string0) throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void endPage(String string, String string0) throws CSSException {
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string0) throws CSSException {
        this.importList.add(string);
    }

    public void namespaceDeclaration(String string, String string0) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
        this.elementList.clear();
        this.test(selectorList);
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
        this.elementList.clear();
    }

    public void endDocument(InputSource inputSource) throws CSSException {
        this.elementList.clear();
    }

    public void startDocument(InputSource inputSource) throws CSSException {
    }

    public void property(String name, LexicalUnit lexicalUnit, boolean b) throws CSSException {
        if (!this.elementList.isEmpty()) {
            String value = this.getValue(lexicalUnit);
            this.putAttribute(name, value);
        }
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
    }

    private String getValue(LexicalUnit lexicalUnit) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.toString(lexicalUnit));
        for (LexicalUnit next = lexicalUnit.getNextLexicalUnit(); next != null; next = next.getNextLexicalUnit()) {
            buf.append(' ');
            buf.append(this.toString(next));
        }
        return buf.toString();
    }

    private String toString(LexicalUnit lexicalUnit) {
        short type = lexicalUnit.getLexicalUnitType();
        switch (type) {
            case 13: {
                return Integer.toString(lexicalUnit.getIntegerValue(), 10);
            }
            case 14: {
                return lexicalUnit.getFloatValue() + "";
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                float f = lexicalUnit.getFloatValue();
                int i = (int)f;
                if ((float)i == f) {
                    return i + lexicalUnit.getDimensionUnitText();
                }
                return f + lexicalUnit.getDimensionUnitText();
            }
            case 27: {
                return this.colorToString(lexicalUnit.getParameters());
            }
            case 35: 
            case 36: 
            case 37: {
                return lexicalUnit.getStringValue();
            }
            case 0: {
                return ",";
            }
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "*";
            }
            case 4: {
                return "/";
            }
            case 5: {
                return "%";
            }
            case 6: {
                return "^";
            }
            case 7: {
                return "<";
            }
            case 8: {
                return ">";
            }
            case 9: {
                return "<=";
            }
            case 10: {
                return "=>";
            }
            case 11: {
                return "~";
            }
        }
        return "";
    }

    private String colorToString(LexicalUnit redLexicalUnit) {
        StringBuffer buf = new StringBuffer();
        buf.append("#");
        this.appendHexaColor(buf, redLexicalUnit.getIntegerValue());
        LexicalUnit green = redLexicalUnit.getNextLexicalUnit().getNextLexicalUnit();
        this.appendHexaColor(buf, green.getIntegerValue());
        LexicalUnit blue = green.getNextLexicalUnit().getNextLexicalUnit();
        this.appendHexaColor(buf, blue.getIntegerValue());
        return buf.toString();
    }

    private void appendHexaColor(StringBuffer buf, int i) {
        String s = Integer.toString(i, 16);
        if (s.length() == 1) {
            buf.append('0');
        }
        buf.append(s);
    }

    private void putAttribute(String name, String value) {
        for (int i = 0; i < this.elementList.size(); ++i) {
            OdElement odClass = this.elementList.get(i);
            odClass.putAttribute(name, value);
        }
    }

    private void test(SelectorList selectorList) {
        int size = selectorList.getLength();
        for (int i = 0; i < size; ++i) {
            Selector selector = selectorList.item(i);
            OdElement abstractElement = this.processSelector(selector);
            if (abstractElement == null) continue;
            this.elementList.add(abstractElement);
        }
    }

    private OdElement processSelector(Selector selector) {
        if (selector instanceof ElementSelector) {
            return this.processElementSelector((ElementSelector)selector);
        }
        if (selector instanceof ConditionalSelector) {
            return this.processConditionalSelector((ConditionalSelector)selector);
        }
        return null;
    }

    private OdElement processElementSelector(ElementSelector elementSelector) {
        String localName = elementSelector.getLocalName();
        if (localName == null) {
            return null;
        }
        return this.elementMaps.getElement(localName, null, true);
    }

    private OdElement processConditionalSelector(ConditionalSelector sel) {
        SimpleSelector ssel = sel.getSimpleSelector();
        if (!(ssel instanceof ElementSelector)) {
            return null;
        }
        String localName = ((ElementSelector)ssel).getLocalName();
        if (localName == null) {
            return null;
        }
        Condition condition = sel.getCondition();
        short conditionType = condition.getConditionType();
        if (condition.getConditionType() == 9) {
            String styleName = ((AttributeCondition)condition).getValue();
            return this.elementMaps.getElement(localName, styleName, true);
        }
        if (condition.getConditionType() == 0) {
            CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
            Condition first = combinatorCondition.getFirstCondition();
            Condition second = combinatorCondition.getSecondCondition();
            if (first.getConditionType() == 9 && second.getConditionType() == 4) {
                String styleName = ((AttributeCondition)first).getValue();
                AttributeCondition attributeCondition = (AttributeCondition)second;
                String attributeName = attributeCondition.getLocalName();
                String attributeValue = attributeCondition.getValue();
                return this.elementMaps.getElement(localName, styleName, attributeName, attributeValue, true);
            }
            return null;
        }
        return null;
    }
}

