/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.Insert;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.fiche.ZoneBlock;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class FicheBlockStorageXMLPart
extends XMLPart {
    public FicheBlockStorageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addFicheBlock(FicheBlock ficheBlock) throws IOException {
        if (ficheBlock instanceof P) {
            this.addP((P)ficheBlock);
        } else if (ficheBlock instanceof H) {
            this.addH((H)ficheBlock);
        } else if (ficheBlock instanceof Ul) {
            this.addUl((Ul)ficheBlock);
        } else if (ficheBlock instanceof Code) {
            this.addCode((Code)ficheBlock);
        } else if (ficheBlock instanceof Table) {
            this.addTable((Table)ficheBlock);
        } else if (ficheBlock instanceof Insert) {
            this.addInsert((Insert)ficheBlock);
        } else if (ficheBlock instanceof Div) {
            this.addDiv((Div)ficheBlock);
        } else if (ficheBlock instanceof Cdatadiv) {
            this.addCdataDiv((Cdatadiv)ficheBlock);
        } else {
            throw new IllegalArgumentException("unknown FicheBlock Implementation");
        }
    }

    public void addFicheBlocks(FicheBlocks ficheBlocks) throws IOException {
        int size = ficheBlocks.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheBlock((FicheBlock)ficheBlocks.get(i));
        }
    }

    public void addTextContent(TextContent content) throws IOException {
        for (Object obj : content) {
            if (obj instanceof String) {
                this.addText((String)obj);
                continue;
            }
            if (!(obj instanceof S)) continue;
            this.addS((S)obj);
        }
    }

    public void addP(P p) throws IOException {
        this.startOpenTag("p");
        this.addAttribute("type", P.typeToString(p.getType()));
        this.addAttribute("source", p.getSource());
        this.addAtts(p);
        this.endOpenTag();
        this.addTextContent(p);
        this.closeTag("p", false);
    }

    public void addH(H h) throws IOException {
        this.startOpenTag("h");
        this.addAttribute("level", String.valueOf(h.getLevel()));
        this.addAtts(h);
        this.endOpenTag();
        this.addTextContent(h);
        this.closeTag("h", false);
    }

    public void addUl(Ul ul) throws IOException {
        this.startOpenTag("ul");
        this.addAtts(ul);
        this.endOpenTag();
        for (Li li : ul) {
            this.addLi(li);
        }
        this.closeTag("ul");
    }

    public void addLi(Li li) throws IOException {
        this.startOpenTag("li");
        this.addAtts(li.getAtts());
        this.endOpenTag();
        this.addFicheBlocks(li);
        this.closeTag("li");
    }

    public void addCode(Code code) throws IOException {
        this.startOpenTag("code");
        this.addAttribute("type", Code.typeToString(code.getType()));
        this.addAtts(code);
        this.endOpenTag();
        this.addZoneBlockElements(code);
        for (Ln ln : code) {
            this.addLn(ln);
        }
        this.closeTag("code");
    }

    public void addLn(Ln ln) throws IOException {
        int indentation = ln.getIndentation();
        this.startOpenTag("ln");
        if (indentation > 0) {
            this.addAttribute("indent", String.valueOf(indentation));
        }
        this.addAtts(ln.getAtts());
        this.endOpenTag();
        this.addText(ln.getValue());
        this.closeTag("ln", false);
    }

    public void addDiv(Div div) throws IOException {
        this.startOpenTag("div");
        XMLUtils.addXmlLangAttribute(this, div.getLang());
        this.addAtts(div);
        this.endOpenTag();
        this.addZoneBlockElements(div);
        this.openTag("fbl");
        this.addFicheBlocks(div);
        this.closeTag("fbl");
        this.closeTag("div");
    }

    public void addCdataDiv(Cdatadiv cdatadiv) throws IOException {
        this.startOpenTag("cdatadiv");
        this.addAtts(cdatadiv);
        this.endOpenTag();
        this.addZoneBlockElements(cdatadiv);
        this.startOpenTag("cdata");
        this.endOpenTag();
        this.addCData(cdatadiv.getCdata());
        this.closeTag("cdata", false);
        this.closeTag("cdatadiv");
    }

    public void addS(S s) throws IOException {
        short sType = s.getType();
        this.startOpenTag("s", false);
        this.addAttribute("type", S.typeToString(sType));
        this.addAttribute("ref", s.getRef());
        this.addAtts(s.getAtts());
        String value = s.getValue();
        if (value.length() > 0) {
            this.endOpenTag();
            this.addText(value);
            this.closeTag("s", false);
        } else {
            this.closeEmptyTag();
        }
    }

    public void addTable(Table table) throws IOException {
        this.startOpenTag("table");
        this.addAtts(table);
        this.endOpenTag();
        this.addZoneBlockElements(table);
        for (Tr tr : table) {
            this.addTr(tr);
        }
        this.closeTag("table");
    }

    public void addTr(Tr tr) throws IOException {
        this.startOpenTag("tr");
        this.addAtts(tr.getAtts());
        this.endOpenTag();
        for (Td td : tr) {
            this.addTd(td);
        }
        this.closeTag("tr");
    }

    public void addTd(Td td) throws IOException {
        this.startOpenTag("td");
        this.addAttribute("type", Td.typeToString(td.getType()));
        this.addAtts(td.getAtts());
        this.endOpenTag();
        this.addTextContent(td);
        this.closeTag("td", false);
    }

    public void addInsert(Insert insert) throws IOException {
        SubsetKey subsetKey;
        int height;
        this.startOpenTag("insert");
        this.addAttribute("type", Insert.typeToString(insert.getType()));
        this.addAttribute("src", insert.getSrc());
        this.addAttribute("ref", insert.getRef());
        this.addAttribute("position", Insert.positionToString(insert.getPosition()));
        int width = insert.getWidth();
        if (width >= 0) {
            this.addAttribute("width", String.valueOf(width));
        }
        if ((height = insert.getHeight()) >= 0) {
            this.addAttribute("height", String.valueOf(height));
        }
        if ((subsetKey = insert.getSubsetKey()) != null) {
            int id = insert.getId();
            if (subsetKey.isAddendaSubset()) {
                this.addAttribute("addenda", subsetKey.getSubsetName());
                this.addAttribute("id", id);
            } else {
                String albumDimName = insert.getAlbumDimName();
                this.addAttribute("album", subsetKey.getSubsetName());
                this.addAttribute("id", id);
                this.addAttribute("albumdim", albumDimName);
            }
        }
        this.addAtts(insert);
        this.endOpenTag();
        this.addZoneBlockElements(insert);
        this.addZoneBlockElement("alt", insert.getAlt());
        this.addZoneBlockElement("credit", insert.getCredit());
        this.closeTag("insert");
    }

    private void addZoneBlockElements(ZoneBlock zoneBlock) throws IOException {
        this.addZoneBlockElement("numero", zoneBlock.getNumero());
        this.addZoneBlockElement("legende", zoneBlock.getLegende());
    }

    private void addZoneBlockElement(String name, TextContent textContent) throws IOException {
        if (!textContent.isEmpty()) {
            this.startOpenTag(name);
            this.endOpenTag();
            this.addTextContent(textContent);
            this.closeTag(name, false);
        }
    }

    private void addAtts(FicheBlock ficheBlock) throws IOException {
        this.addAtts(ficheBlock.getAtts());
    }

    private void addAtts(Atts atts) throws IOException {
        int attLength = atts.size();
        for (int i = 0; i < attLength; ++i) {
            this.addAttribute("att-" + atts.getName(i), atts.getValue(i));
        }
    }
}

