/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.defs;

import java.io.IOException;
import net.fichotheque.exportation.scrutari.CorpusScrutariDef;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.scrutari.ThesaurusScrutariDef;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.utils.FichothequeXMLUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class ScrutariExportDefXMLPart
extends XMLPart {
    public ScrutariExportDefXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public ScrutariExportDefXMLPart addScrutariExportDef(ScrutariExportDef scrutariExportDef) throws IOException {
        Labels longIntitule;
        this.openTag("scrutariexport");
        LabelUtils.addLabels(this, scrutariExportDef.getTitleLabels());
        this.addSimpleElement("authority", scrutariExportDef.getAuthority());
        this.addSimpleElement("base-name", scrutariExportDef.getBaseName());
        this.addSimpleElement("base-icon", scrutariExportDef.getBaseIcon());
        Langs uiLangs = scrutariExportDef.getUiLangs();
        if (!uiLangs.isEmpty()) {
            this.openTag("langs-ui");
            for (Lang lang : uiLangs) {
                this.addSimpleElement("lang", lang.toString());
            }
            this.closeTag("langs-ui");
        }
        this.addHrefPattern(scrutariExportDef.getFicheHrefPattern(), "fiche-pattern");
        this.addHrefPattern(scrutariExportDef.getMotcleHrefPattern(), "motcle-pattern");
        Labels shortIntitule = scrutariExportDef.getCustomBaseIntitule(1);
        if (shortIntitule != null) {
            this.openTag("intitule-short");
            LabelUtils.addLabels(this, shortIntitule);
            this.closeTag("intitule-short");
        }
        if ((longIntitule = scrutariExportDef.getCustomBaseIntitule(2)) != null) {
            this.openTag("intitule-long");
            LabelUtils.addLabels(this, longIntitule);
            this.closeTag("intitule-long");
        }
        this.addSimpleElement("target-name", scrutariExportDef.getTargetName());
        this.addSimpleElement("target-path", scrutariExportDef.getTargetPath().toString());
        for (String includeToken : scrutariExportDef.getIncludeTokenList()) {
            this.addSimpleElement("include-token", includeToken);
        }
        for (CorpusScrutariDef corpusScrutariDef : scrutariExportDef.getCorpusScrutariDefList()) {
            this.addCorpusScrutariDef(corpusScrutariDef);
        }
        for (ThesaurusScrutariDef thesaurusScrutariDef : scrutariExportDef.getThesaurusScrutariDefList()) {
            this.addThesaurusScrutariDef(thesaurusScrutariDef);
        }
        FichothequeXMLUtils.writeSelectionOptions(this, scrutariExportDef.getSelectionOptions());
        AttributeUtils.addAttributes(this, scrutariExportDef.getAttributes());
        this.closeTag("scrutariexport");
        return this;
    }

    private void addHrefPattern(AccoladePattern hrefPattern, String tagName) throws IOException {
        if (hrefPattern == null) {
            return;
        }
        this.addSimpleElement(tagName, hrefPattern.toString());
    }

    private void addCorpusScrutariDef(CorpusScrutariDef corpusScrutariDef) throws IOException {
        this.startOpenTag("corpus-def");
        this.addAttribute("corpus", corpusScrutariDef.getCorpusKey().getSubsetName());
        this.endOpenTag();
        FormatSourceKey formatSourceKey = corpusScrutariDef.getDateFormatSourceKey();
        if (formatSourceKey != null) {
            this.addSimpleElement("date", formatSourceKey.getKeyString());
        }
        this.openTag("field-generation");
        this.addCData(corpusScrutariDef.getFieldGenerationSource());
        this.closeTag("field-generation", false);
        this.addHrefPattern(corpusScrutariDef.getHrefPattern(), "href-pattern");
        String multilangMode = corpusScrutariDef.getMultilangMode();
        if (multilangMode != null) {
            this.startOpenTag("multilang");
            this.addAttribute("mode", multilangMode);
            String multilangParam = corpusScrutariDef.getMultilangParam();
            if (multilangParam != null) {
                this.addAttribute("param", multilangParam);
            }
            this.closeEmptyTag();
        }
        for (String includeToken : corpusScrutariDef.getIncludeTokenList()) {
            this.addSimpleElement("include-token", includeToken);
        }
        this.closeTag("corpus-def");
    }

    private void addThesaurusScrutariDef(ThesaurusScrutariDef thesaurusScrutariDef) throws IOException {
        this.startOpenTag("thesaurus-def");
        this.addAttribute("thesaurus", thesaurusScrutariDef.getThesaurusKey().getSubsetName());
        this.endOpenTag();
        this.openTag("field-generation");
        this.addCData(thesaurusScrutariDef.getFieldGenerationSource());
        this.closeTag("field-generation", false);
        if (thesaurusScrutariDef.isWholeThesaurus()) {
            this.addEmptyElement("whole-thesaurus");
        }
        for (String includeToken : thesaurusScrutariDef.getIncludeTokenList()) {
            this.addSimpleElement("include-token", includeToken);
        }
        this.closeTag("thesaurus-def");
    }

    public static ScrutariExportDefXMLPart init(XMLWriter xmlWriter) {
        return new ScrutariExportDefXMLPart(xmlWriter);
    }
}

