/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.Tie;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.attr.Attributes;

class FilteredJunctionBuilder {
    private final Junction source;
    private final Map<String, Tie> tieMap = new LinkedHashMap<String, Tie>();

    FilteredJunctionBuilder(Junction source) {
        this.source = source;
    }

    void testCondition(JunctionCondition junctionCondition) {
        if (junctionCondition == null) {
            for (Tie tie : this.source.getTieList()) {
                this.addTie(tie);
            }
            return;
        }
        List<String> modeList = junctionCondition.getTieModeList();
        RangeCondition weightCondition = junctionCondition.getWeightRangeCondition();
        if (weightCondition != null) {
            if (modeList.isEmpty()) {
                for (Tie tie : this.source.getTieList()) {
                    if (!weightCondition.accept(tie.getWeight())) continue;
                    this.addTie(tie);
                }
            } else {
                for (String mode : modeList) {
                    Tie tie = this.source.getTieByMode(mode);
                    if (tie == null || !weightCondition.accept(tie.getWeight())) continue;
                    this.addTie(tie);
                }
            }
        } else {
            for (String mode : modeList) {
                Tie tie = this.source.getTieByMode(mode);
                if (tie == null) continue;
                this.addTie(tie);
            }
        }
    }

    void addTie(Tie tie) {
        this.tieMap.put(tie.getMode(), tie);
    }

    Junction toJunction() {
        int size = this.tieMap.size();
        if (size == 0) {
            return null;
        }
        return new InternalFilteredJunction(this.source, this.tieMap.values().toArray(new Tie[size]));
    }

    private static class InternalFilteredJunction
    implements Junction {
        private final Junction source;
        private final Tie[] tieArray;
        private final List<Tie> tieList;

        private InternalFilteredJunction(Junction source, Tie[] tieArray) {
            this.source = source;
            this.tieArray = tieArray;
            this.tieList = JunctionUtils.wrap(tieArray);
        }

        @Override
        public JunctionKey getJunctionKey() {
            return this.source.getJunctionKey();
        }

        @Override
        public List<Tie> getTieList() {
            return this.tieList;
        }

        @Override
        public Tie getTieByMode(String mode) {
            for (Tie tie : this.tieArray) {
                if (!tie.getMode().equals(mode)) continue;
                return tie;
            }
            return null;
        }

        @Override
        public Attributes getAttributes() {
            return this.source.getAttributes();
        }
    }
}

