/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FieldContentCondition;
import net.fichotheque.selection.FieldTest;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.PeriodCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.selection.UserCondition;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.selection.FieldTestFactory;
import net.fichotheque.utils.selection.FilteredJunctionBuilder;
import net.mapeadores.util.date.DateFilter;
import net.mapeadores.util.date.DateFilterFactory;
import net.mapeadores.util.date.DateFilterUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.SwitchException;

class FicheSelectEngine {
    private static final FieldKey[] titreScopeArray = new FieldKey[]{FieldKey.TITLE};
    private final FicheQuery ficheQuery;
    private final Redacteur[] redacteurArray;
    private final Sphere[] sphereArray;
    private final FieldTest fieldTest;
    private final FieldKey geolocalisationFieldKey;
    private final boolean onCreationDate;
    private final boolean onModificationDate;
    private final List<FieldKey> periodFieldKeyList;
    private final DateFilter dateFilter;
    private final JunctionCondition junctionCondition;
    private final Predicate<FicheMeta> relationPredicate;
    private final String userFilter;

    private FicheSelectEngine(CorpusMetadata corpusMetadata, FicheQuery ficheQuery, JunctionCondition junctionCondition, FieldTest fieldTest, Predicate<FicheMeta> relationPredicate) {
        CorpusField corpusField;
        this.ficheQuery = ficheQuery;
        this.fieldTest = fieldTest;
        this.junctionCondition = junctionCondition;
        this.relationPredicate = relationPredicate;
        Fichotheque fichotheque = corpusMetadata.getCorpus().getFichotheque();
        UserCondition userCondition = ficheQuery.getUserCondition();
        if (userCondition != null && userCondition.isSome()) {
            Object[] array = FicheSelectEngine.initArrays(fichotheque, userCondition);
            this.redacteurArray = (Redacteur[])array[0];
            this.sphereArray = (Sphere[])array[1];
        } else {
            this.redacteurArray = null;
            this.sphereArray = null;
        }
        String string = this.userFilter = userCondition == null ? "" : userCondition.getFilter();
        this.geolocalisationFieldKey = ficheQuery.isWithGeoloc() ? ((corpusField = corpusMetadata.getGeolocalisationField()) != null ? corpusField.getFieldKey() : null) : null;
        PeriodCondition periodCondition = ficheQuery.getPeriodCondition();
        if (periodCondition != null) {
            this.dateFilter = FicheSelectEngine.toDateFilter(periodCondition);
            this.periodFieldKeyList = FicheSelectEngine.toPeriodFieldKeyList(corpusMetadata, periodCondition);
            this.onCreationDate = periodCondition.isOnCreationDate();
            this.onModificationDate = periodCondition.isOnModificationDate();
        } else {
            this.dateFilter = null;
            this.periodFieldKeyList = null;
            this.onCreationDate = false;
            this.onModificationDate = false;
        }
    }

    void filter(FichePointeur fichePointeur, FilteredJunctionBuilder builder) {
        if (!this.isSelected(fichePointeur)) {
            return;
        }
        builder.testCondition(this.junctionCondition);
    }

    boolean isSelected(FichePointeur fichePointeur) {
        FicheMeta ficheMeta = (FicheMeta)fichePointeur.getCurrentSubsetItem();
        switch (this.ficheQuery.getDiscardFilter()) {
            case "none": {
                if (!ficheMeta.isDiscarded()) break;
                return false;
            }
            case "only": {
                if (ficheMeta.isDiscarded()) break;
                return false;
            }
        }
        RangeCondition rangeCondition = this.ficheQuery.getIdRangeCondition();
        if (rangeCondition != null && !rangeCondition.accept(ficheMeta.getId())) {
            return false;
        }
        switch (this.userFilter) {
            case "some": {
                if (this.isRedacteurSelected(ficheMeta)) break;
                return false;
            }
            case "any": {
                if (!ficheMeta.getUserGlobalIdList().isEmpty()) break;
                return false;
            }
            case "none": {
                if (ficheMeta.getUserGlobalIdList().isEmpty()) break;
                return false;
            }
        }
        if (this.relationPredicate != null && !this.relationPredicate.test(ficheMeta)) {
            return false;
        }
        if (this.fieldTest != null && !this.fieldTest.success(fichePointeur)) {
            return false;
        }
        if (this.ficheQuery.isWithGeoloc()) {
            if (this.geolocalisationFieldKey == null) {
                return false;
            }
            Object obj = fichePointeur.getValue(this.geolocalisationFieldKey);
            if (obj == null || !(obj instanceof GeopointItem)) {
                return false;
            }
        }
        return this.dateFilter == null || this.testDateFilter(fichePointeur, ficheMeta);
    }

    private boolean testDateFilter(FichePointeur fichePointeur, FicheMeta ficheMeta) {
        if (this.onCreationDate && this.dateFilter.containsDate(ficheMeta.getCreationDate())) {
            return true;
        }
        if (this.onModificationDate && this.dateFilter.containsDate(ficheMeta.getModificationDate())) {
            return true;
        }
        if (this.periodFieldKeyList != null) {
            for (FieldKey fieldKey : this.periodFieldKeyList) {
                Object value = fichePointeur.getValue(fieldKey);
                if (value == null) continue;
                if (value instanceof DateItem) {
                    if (!this.dateFilter.containsDate(((DateItem)value).getDate())) continue;
                    return true;
                }
                if (!(value instanceof FicheItems)) continue;
                for (FicheItem ficheItem : (FicheItems)value) {
                    if (!(ficheItem instanceof DateItem) || !this.dateFilter.containsDate(((DateItem)ficheItem).getDate())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static FicheSelectEngine newInstance(CorpusMetadata corpusMetadata, FicheQuery ficheQuery, JunctionCondition junctionCondition, SelectionContext selectionContext, Predicate<FicheMeta> motcleConditionPredicate) {
        FieldTest fieldTest = null;
        FieldContentCondition fieldContentCondition = ficheQuery.getFieldContentCondition();
        if (fieldContentCondition != null) {
            String scope = fieldContentCondition.getScope();
            FieldKey[] fieldKeyArray = null;
            switch (scope) {
                case "title": {
                    fieldKeyArray = titreScopeArray;
                    break;
                }
                case "head": {
                    fieldKeyArray = CorpusMetadataUtils.getEnteteFieldKeyArray(corpusMetadata);
                    break;
                }
                case "fiche": {
                    fieldKeyArray = CorpusMetadataUtils.getFicheFieldKeyArray(corpusMetadata);
                    break;
                }
                case "selection": {
                    List<FieldKey> fieldKeyList = fieldContentCondition.getFieldKeyList();
                    fieldKeyArray = fieldKeyList.toArray(new FieldKey[fieldKeyList.size()]);
                    break;
                }
                default: {
                    throw new SwitchException("scope: " + scope);
                }
            }
            fieldTest = FieldTestFactory.newFieldTest(fieldContentCondition.getTextCondition(), selectionContext, fieldKeyArray);
        }
        return new FicheSelectEngine(corpusMetadata, ficheQuery, junctionCondition, fieldTest, motcleConditionPredicate);
    }

    private boolean isRedacteurSelected(FicheMeta ficheMeta) {
        if (this.sphereArray != null) {
            for (Sphere sphere : this.sphereArray) {
                if (!ficheMeta.belongsToSphere(sphere.getSubsetName())) continue;
                return true;
            }
        }
        if (this.redacteurArray != null) {
            for (Redacteur redacteur : this.redacteurArray) {
                if (!ficheMeta.belongsTo(redacteur.getGlobalId())) continue;
                return true;
            }
        }
        return false;
    }

    private static Object[] initArrays(Fichotheque fichotheque, UserCondition userCondition) {
        ArrayList<Redacteur> redacteurList = new ArrayList<Redacteur>();
        ArrayList<Sphere> sphereList = new ArrayList<Sphere>();
        for (UserCondition.Entry entry : userCondition.getEntryList()) {
            Redacteur redacteur;
            Sphere sphere = fichotheque.getSphere(entry.getSphereName());
            if (sphere == null) continue;
            if (entry instanceof UserCondition.LoginEntry) {
                redacteur = sphere.getRedacteurByLogin(((UserCondition.LoginEntry)entry).getLogin());
                if (redacteur == null) continue;
                redacteurList.add(redacteur);
                continue;
            }
            if (entry instanceof UserCondition.IdEntry) {
                redacteur = sphere.getRedacteurById(((UserCondition.IdEntry)entry).getId());
                if (redacteur == null) continue;
                redacteurList.add(redacteur);
                continue;
            }
            sphereList.add(sphere);
        }
        Object[] result = new Object[]{redacteurList.toArray(new Redacteur[redacteurList.size()]), sphereList.toArray(new Sphere[sphereList.size()])};
        return result;
    }

    private static List<FieldKey> toPeriodFieldKeyList(CorpusMetadata corpusMetadata, PeriodCondition periodCondition) {
        List<FieldKey> fieldKeyList = periodCondition.getFieldKeyList();
        if (fieldKeyList.isEmpty()) {
            return null;
        }
        ArrayList<FieldKey> list = new ArrayList<FieldKey>();
        for (FieldKey fieldKey : fieldKeyList) {
            if (corpusMetadata.getCorpusField(fieldKey) == null) continue;
            list.add(fieldKey);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static DateFilter toDateFilter(PeriodCondition periodCondition) {
        String startType = periodCondition.getStartType();
        String endType = periodCondition.getEndType();
        if (startType.equals("date")) {
            FuzzyDate startDate = periodCondition.getStartDate();
            switch (endType) {
                case "same": {
                    return DateFilterFactory.newInstance(startDate);
                }
                case "date": {
                    return DateFilterFactory.newInstance(startDate, periodCondition.getEndDate());
                }
                case "any": {
                    return DateFilterFactory.newMinimumFilter(startDate);
                }
            }
            throw new SwitchException("Unknown PeriodCondition.getEndType() value: " + endType);
        }
        if (startType.equals("any")) {
            switch (endType) {
                case "same": 
                case "any": {
                    return DateFilterUtils.NOTNULL_FILTER;
                }
                case "date": {
                    return DateFilterFactory.newMaximumFilter(periodCondition.getEndDate());
                }
            }
            throw new SwitchException("Unknown PeriodCondition.getEndType() value: " + endType);
        }
        throw new SwitchException("Unknown PeriodCondition.getStartType() value: " + startType);
    }
}

