/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDef;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.namespaces.TransformationSpace;
import net.fichotheque.utils.ExtractionUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;

public final class TransformationUtils {
    public static final List<TemplateDescription> EMPTY_TEMPLATEDESCRIPTIONLIST = Collections.emptyList();

    private TransformationUtils() {
    }

    public static boolean isUseableTemplateState(String state) {
        switch (state) {
            case "ok": 
            case "with_warnings": {
                return true;
            }
        }
        return false;
    }

    public static TransformationDescription getEmptyTransformationDescription(TransformationKey transformationKey) {
        return new EmptyTransformationDescription(transformationKey);
    }

    public static List<TemplateDescription> wrap(TemplateDescription[] array) {
        return new TemplateDescriptionList(array);
    }

    public static List<TemplateContentDescription> wrap(TemplateContentDescription[] array) {
        return new TemplateContentList(array);
    }

    public static int getExtractVersion(Attributes attributes) {
        String text = null;
        Attribute attribute = attributes.getAttribute(TransformationSpace.EXTRACTVERSION_KEY);
        if (attribute != null) {
            text = attribute.getFirstValue();
        }
        return ExtractionUtils.parseExtractVersion(text);
    }

    public static boolean isWithEmptyComponents(Attributes attributes, boolean defaultValue) {
        Attribute attribute = attributes.getAttribute(TransformationSpace.EMPTYCOMPONENTS_KEY);
        if (attribute == null) {
            return defaultValue;
        }
        return StringUtils.toBoolean(attribute.getFirstValue(), defaultValue);
    }

    public static TemplateDef deriveTemplateDef(TemplateDef originalTemplateDef, TemplateKey newTemplateKey) {
        return new DerivedTemplateDef(originalTemplateDef, newTemplateKey);
    }

    private static class EmptyTransformationDescription
    implements TransformationDescription {
        private final TransformationKey transformationKey;

        private EmptyTransformationDescription(TransformationKey transformationKey) {
            this.transformationKey = transformationKey;
        }

        @Override
        public TransformationKey getTransformationKey() {
            return this.transformationKey;
        }

        @Override
        public List<TemplateDescription> getSimpleTemplateDescriptionList() {
            return EMPTY_TEMPLATEDESCRIPTIONLIST;
        }

        @Override
        public List<TemplateDescription> getStreamTemplateDescriptionList() {
            return EMPTY_TEMPLATEDESCRIPTIONLIST;
        }
    }

    private static class TemplateDescriptionList
    extends AbstractList<TemplateDescription>
    implements RandomAccess {
        private final TemplateDescription[] array;

        private TemplateDescriptionList(TemplateDescription[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TemplateDescription get(int index) {
            return this.array[index];
        }
    }

    private static class TemplateContentList
    extends AbstractList<TemplateContentDescription>
    implements RandomAccess {
        private final TemplateContentDescription[] array;

        private TemplateContentList(TemplateContentDescription[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TemplateContentDescription get(int index) {
            return this.array[index];
        }
    }

    private static class DerivedTemplateDef
    implements TemplateDef {
        private final TemplateKey templateKey;
        private final TemplateDef originalTemplateDef;

        private DerivedTemplateDef(TemplateDef originalTemplateDef, TemplateKey templateKey) {
            this.templateKey = templateKey;
            this.originalTemplateDef = originalTemplateDef;
        }

        @Override
        public TemplateKey getTemplateKey() {
            return this.templateKey;
        }

        @Override
        public Labels getTitleLabels() {
            return this.originalTemplateDef.getTitleLabels();
        }

        @Override
        public Attributes getAttributes() {
            return this.originalTemplateDef.getAttributes();
        }
    }
}

