/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.fichotheque.EditOrigin;

public final class EditOriginUtils {
    private EditOriginUtils() {
    }

    public static EditOrigin newEditOrigin(String source) {
        return new InternalEditOrigin(null, null, EditOriginUtils.getCurrentGMT(), source);
    }

    public static EditOrigin newEditOrigin(String source, String sessionId, String redacteurGlobalId) {
        return new InternalEditOrigin(sessionId, redacteurGlobalId, EditOriginUtils.getCurrentGMT(), source);
    }

    public static EditOrigin newEditOrigin(String source, String sessionId, String redacteurGlobalId, String isoTime) {
        return new InternalEditOrigin(sessionId, redacteurGlobalId, isoTime, source);
    }

    private static String getCurrentGMT() {
        ZonedDateTime currentDateTime = ZonedDateTime.now(ZoneOffset.UTC).withNano(0);
        return currentDateTime.toString();
    }

    private static class InternalEditOrigin
    implements EditOrigin {
        private final String redacteurGlobalId;
        private final String isoTime;
        private final String source;
        private final String sessionId;

        private InternalEditOrigin(String sessionId, String redacteurGlobalId, String isoTime, String source) {
            this.sessionId = sessionId;
            this.redacteurGlobalId = redacteurGlobalId;
            this.isoTime = isoTime;
            this.source = source;
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public String getRedacteurGlobalId() {
            return this.redacteurGlobalId;
        }

        @Override
        public String getISOTime() {
            return this.isoTime;
        }

        @Override
        public String getSource() {
            return this.source;
        }
    }
}

