/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.fichotheque.tools.selection.SelectionDefBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class SelectionDefDOMReader {
    private final Fichotheque fichotheque;
    private final SelectionDefBuilder selectionDefBuilder;
    private final MessageHandler messageHandler;

    public SelectionDefDOMReader(Fichotheque fichotheque, SelectionDefBuilder selectionDefBuilder, MessageHandler messageHandler) {
        this.fichotheque = fichotheque;
        this.selectionDefBuilder = selectionDefBuilder;
        this.messageHandler = messageHandler;
    }

    public SelectionDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static SelectionDefDOMReader init(Fichotheque fichotheque, SelectionDefBuilder selectionDefBuilder, MessageHandler messageHandler) {
        return new SelectionDefDOMReader(fichotheque, selectionDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": {
                    try {
                        LabelUtils.readLabel(element, SelectionDefDOMReader.this.selectionDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(SelectionDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(SelectionDefDOMReader.this.selectionDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                default: {
                    if (SelectionDOMUtils.readQueryElement(SelectionDefDOMReader.this.selectionDefBuilder.getFichothequeQueriesBuilder(), SelectionDefDOMReader.this.fichotheque, element)) break;
                    DomMessages.unknownTagWarning(SelectionDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

