/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.RangeCondition;
import net.mapeadores.util.text.StringUtils;

public class JunctionConditionBuilder {
    private final Set<String> modeSet = new LinkedHashSet<String>();
    private RangeCondition weightRangeCondition = null;

    public JunctionConditionBuilder addTieMode(String mode) {
        if (mode.equals("_default")) {
            mode = "";
        }
        this.modeSet.add(mode);
        return this;
    }

    public JunctionConditionBuilder setWeightRangeCondition(RangeCondition weightRangeCondition) {
        this.weightRangeCondition = weightRangeCondition;
        return this;
    }

    public boolean isEmpty() {
        return this.weightRangeCondition == null && this.modeSet.isEmpty();
    }

    public JunctionCondition toJunctionCondition() {
        int size = this.modeSet.size();
        List<String> tieModeList = size > 0 ? StringUtils.wrap(this.modeSet.toArray(new String[size])) : StringUtils.EMPTY_STRINGLIST;
        return new InternalJunctionCondition(tieModeList, this.weightRangeCondition);
    }

    public static JunctionConditionBuilder init() {
        return new JunctionConditionBuilder();
    }

    private static class InternalJunctionCondition
    implements JunctionCondition {
        private final List<String> tieModeList;
        private final RangeCondition weightRangeCondition;

        private InternalJunctionCondition(List<String> tieModeList, RangeCondition weightRangeCondition) {
            this.tieModeList = tieModeList;
            this.weightRangeCondition = weightRangeCondition;
        }

        @Override
        public List<String> getTieModeList() {
            return this.tieModeList;
        }

        @Override
        public RangeCondition getWeightRangeCondition() {
            return this.weightRangeCondition;
        }
    }
}

