/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.tools.parsers.LineInfo;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.ficheblock.BlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.text.StringUtils;

class TableParser
extends BlockParser {
    private static final int HORIZONTALHEADER_BITVALUE = 1;
    private static final int VERTICALHEADER_BITVALUE = 2;
    private final ImportParser importParser = new ImportParser();
    private final SyntaxParser syntaxParser;
    private final TextContentParser textContentParser;
    private final boolean withLineNumber;

    TableParser(TextContentParser textContentParser, boolean withLineNumber) {
        this.textContentParser = textContentParser;
        this.syntaxParser = new SyntaxParser(textContentParser);
        this.withLineNumber = withLineNumber;
    }

    @Override
    public boolean isStartLine(String line) {
        return line.startsWith("===");
    }

    @Override
    public void parse(String[] lineArray, int startIndex, Atts initAtts) {
        InternalParser internalParser;
        String firstLine = StringUtils.cleanString(lineArray[startIndex]);
        Table table = new Table();
        FicheUtils.populate(table, initAtts);
        char carac = this.initSeparator(firstLine);
        if (carac == '0') {
            internalParser = this.syntaxParser;
        } else {
            this.importParser.setSeparator(carac);
            internalParser = this.importParser;
        }
        internalParser.setTable(table);
        internalParser.setHeaderMask(this.getHeaderMask(firstLine));
        int beginIndex = BlockParser.parseZoneBlockElements(table, startIndex + 1, lineArray, this.textContentParser);
        int stop = lineArray.length - 1;
        for (int i = beginIndex; i <= stop; ++i) {
            String line = lineArray[i];
            if (line.trim().startsWith("===")) {
                stop = i;
                break;
            }
            internalParser.parseLine(line, this.withLineNumber ? i : -1);
        }
        internalParser.flush();
        this.setParseResult(stop, table);
    }

    private int getHeaderMask(String s) {
        int headerMask = 0;
        if (s.indexOf(104) != -1) {
            headerMask |= 1;
        }
        if (s.indexOf(118) != -1) {
            headerMask |= 2;
        }
        return headerMask;
    }

    private char initSeparator(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case 't': {
                    return '\t';
                }
                case ',': {
                    return ',';
                }
                case ';': {
                    return ';';
                }
                case ':': {
                    return ':';
                }
                case '|': {
                    return '|';
                }
                case '*': {
                    return '*';
                }
            }
        }
        return '0';
    }

    private static class ImportParser
    extends InternalParser {
        private char separator = (char)9;

        private ImportParser() {
        }

        @Override
        public void parseLine(String line, int lineIndex) {
            if (line.length() == 0) {
                return;
            }
            Tr tr = new Tr();
            StringBuilder buf = new StringBuilder();
            int q = 0;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == this.separator) {
                    Td td = new Td(this.checkType((short)1, q));
                    td.addText(StringUtils.cleanString(buf.toString()));
                    tr.add(td);
                    buf = new StringBuilder();
                    ++q;
                    continue;
                }
                buf.append(c);
            }
            String result = StringUtils.cleanString(buf.toString());
            if (result.length() == 0) {
                if (tr.isEmpty()) {
                    return;
                }
            } else {
                Td td = new Td(this.checkType((short)1, q));
                td.addText(result);
                tr.add(td);
            }
            this.addRow(tr);
        }

        @Override
        public void reinit() {
        }

        public void setSeparator(char separator) {
            this.separator = separator;
        }

        @Override
        public void flush() {
        }
    }

    private static class SyntaxParser
    extends InternalParser {
        private final TextContentParser parser;
        private Tr currentRow;
        private int tdIndex = 0;
        private Atts potentialTrAtts = null;

        private SyntaxParser(TextContentParser parser) {
            this.parser = parser;
        }

        @Override
        public void parseLine(String line, int lineIndex) {
            line = StringUtils.cleanString(line);
            LineInfo lineInfo = LineInfo.parse(line, lineIndex);
            if ((line = lineInfo.getCleanedLine()).length() == 0) {
                this.flush();
                this.potentialTrAtts = lineInfo.getFirstAtts();
            } else {
                short tdType = 1;
                if (line.startsWith("#")) {
                    tdType = 2;
                    line = line.substring(1).trim();
                }
                if (line.equals("-")) {
                    line = "";
                }
                if (this.currentRow == null) {
                    this.currentRow = new Tr();
                    if (this.potentialTrAtts != null) {
                        FicheUtils.populate(this.currentRow, this.potentialTrAtts);
                    }
                }
                Td td = new Td(this.checkType(tdType, this.tdIndex));
                ++this.tdIndex;
                if (lineInfo.hasAttsError()) {
                    td.addText(line);
                } else {
                    FicheUtils.populate(td, lineInfo.getFirstAtts());
                    this.parser.parse(td, line);
                }
                this.currentRow.add(td);
            }
        }

        @Override
        public void flush() {
            if (this.currentRow != null) {
                this.addRow(this.currentRow);
                this.currentRow = null;
                this.potentialTrAtts = null;
                this.tdIndex = 0;
            }
        }

        @Override
        public void reinit() {
            this.currentRow = null;
            this.tdIndex = 0;
        }
    }

    private static abstract class InternalParser {
        Table table;
        int headerMask;
        int rowIndex;

        private InternalParser() {
        }

        public abstract void parseLine(String var1, int var2);

        public abstract void flush();

        public abstract void reinit();

        public void setTable(Table table) {
            this.table = table;
            this.rowIndex = 0;
            this.reinit();
        }

        public void setHeaderMask(int headerMask) {
            this.headerMask = headerMask;
        }

        protected short checkType(short type, int colIndex) {
            if (type == 2) {
                return 2;
            }
            if (this.rowIndex == 0 && (this.headerMask & 1) != 0) {
                return 2;
            }
            if (colIndex == 0 && (this.headerMask & 2) != 0) {
                return 2;
            }
            return 1;
        }

        protected Td createTd(int colIndex) {
            if (this.rowIndex == 0 && (this.headerMask & 1) != 0) {
                return new Td(2);
            }
            if (colIndex == 0 && (this.headerMask & 2) != 0) {
                return new Td(2);
            }
            return new Td();
        }

        protected void addRow(Tr tr) {
            this.table.add(tr);
            ++this.rowIndex;
        }
    }
}

