/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import java.util.List;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.tools.parsers.LineInfo;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.ficheblock.BlockParser;
import net.fichotheque.tools.parsers.ficheblock.CdatadivParser;
import net.fichotheque.tools.parsers.ficheblock.CodeParser;
import net.fichotheque.tools.parsers.ficheblock.DivParser;
import net.fichotheque.tools.parsers.ficheblock.InsertParser;
import net.fichotheque.tools.parsers.ficheblock.ParagraphState;
import net.fichotheque.tools.parsers.ficheblock.TableParser;
import net.fichotheque.tools.parsers.ficheblock.UlParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.TypoOptions;

public class FicheBlockParser {
    public static final short MODE_FORMULAIRE = 1;
    public static final short MODE_EXPORT = 2;
    private final TextContentParser textContentParser;
    private final BlockParser tableParser;
    private final BlockParser codeParser;
    private final BlockParser ulParser;
    private final BlockParser insertParser;
    private final BlockParser divParser;
    private final BlockParser cdatadivParser;
    private final ParagraphState paragraphState = new ParagraphState();
    private final boolean withLineNumber;

    public FicheBlockParser(HtmlCleaner htmlCleaner, TypoOptions typoOptions, boolean withLineNumber) {
        this.textContentParser = new TextContentParser(typoOptions);
        this.tableParser = new TableParser(this.textContentParser, withLineNumber);
        this.codeParser = new CodeParser(this.textContentParser, withLineNumber);
        this.ulParser = new UlParser(this.textContentParser, withLineNumber);
        this.insertParser = new InsertParser(this.textContentParser);
        this.divParser = new DivParser(this.textContentParser, typoOptions, htmlCleaner, withLineNumber);
        this.cdatadivParser = new CdatadivParser(this.textContentParser, htmlCleaner);
        this.withLineNumber = withLineNumber;
    }

    public void parseFicheBlockList(String string, List<FicheBlock> list) {
        if (string.length() == 0) {
            return;
        }
        this.reinit();
        String[] lines = StringUtils.getLineTokens(string, (short)0);
        for (int k = 0; k < lines.length; ++k) {
            k = this.parseLine(lines, k, list);
        }
    }

    public void reinit() {
        this.paragraphState.reinit();
    }

    public int parseLine(String[] lineArray, int lineIndex, List<FicheBlock> ficheBlockList) {
        String line = StringUtils.cleanString(lineArray[lineIndex]);
        if (line.length() == 0) {
            this.paragraphState.flushPreviousAtts(ficheBlockList);
            this.paragraphState.increaseWhiteLineCount();
            return lineIndex;
        }
        BlockParser specificBlockParser = this.checkSpecificBlockParser(line);
        if (specificBlockParser != null) {
            Atts initAtts = this.paragraphState.getPreviousAtts();
            if (initAtts == null && this.withLineNumber) {
                initAtts = LineInfo.getAutomaticAtts(lineIndex);
            }
            specificBlockParser.parse(lineArray, lineIndex, initAtts);
            FicheBlock ficheBlock = specificBlockParser.getFicheBlock();
            if (ficheBlock != null) {
                ficheBlockList.add(ficheBlock);
            }
            int newLineIndex = specificBlockParser.getEndIndex();
            this.paragraphState.reinit();
            return newLineIndex;
        }
        this.paragraphState.flushPreviousAtts(ficheBlockList);
        LineInfo lineInfo = LineInfo.parse(line, this.withLineNumber ? lineIndex : -1);
        if (lineInfo.isCleanedLineEmpty()) {
            this.paragraphState.setPreviousAtts(lineInfo.getFirstAtts());
        } else {
            FicheBlock prg = FicheBlockParser.parseLine(lineInfo, this.textContentParser);
            if (prg instanceof H) {
                this.paragraphState.checkH();
            } else {
                this.paragraphState.flushWhiteLines(ficheBlockList);
            }
            ficheBlockList.add(prg);
        }
        return lineIndex;
    }

    private BlockParser checkSpecificBlockParser(String line) {
        if (this.codeParser.isStartLine(line)) {
            return this.codeParser;
        }
        if (this.tableParser.isStartLine(line)) {
            return this.tableParser;
        }
        if (this.insertParser.isStartLine(line)) {
            return this.insertParser;
        }
        if (this.cdatadivParser.isStartLine(line)) {
            return this.cdatadivParser;
        }
        if (this.divParser.isStartLine(line)) {
            return this.divParser;
        }
        if (this.ulParser.isStartLine(line)) {
            return this.ulParser;
        }
        return null;
    }

    public static FicheBlock parseLine(LineInfo lineInfo, TextContentParser textContentParser) {
        String line = lineInfo.getCleanedLine();
        if (lineInfo.hasAttsError()) {
            P p = new P();
            p.addText(line);
            return p;
        }
        if (line.length() > 0 && line.charAt(0) == '#') {
            H h = FicheBlockParser.parseH(line, textContentParser);
            FicheUtils.populate(h, lineInfo.getFirstAtts());
            return h;
        }
        P p = FicheBlockParser.parseP(line, textContentParser);
        FicheUtils.populate(p, lineInfo.getFirstAtts());
        return p;
    }

    public static H parseH(String line, TextContentParser textContentParser) {
        char carac;
        int level = 1;
        for (int i = 1; i < line.length() && (carac = line.charAt(i)) == '#'; ++i) {
            ++level;
        }
        H h = new H(level);
        textContentParser.parse(h, line.substring(level).trim());
        return h;
    }

    public static P parseP(String line, TextContentParser textContentParser) {
        if (line.length() == 0) {
            P p = new P();
            return p;
        }
        short type = 0;
        switch (line.charAt(0)) {
            case '>': {
                type = 1;
                break;
            }
            case '?': {
                type = 3;
                break;
            }
            case '!': {
                type = 4;
            }
        }
        if (type != 0) {
            line = line.substring(1).trim();
        }
        P p = new P(type);
        int length = line.length();
        if (length > 0 && line.charAt(0) == '@') {
            StringBuilder sourceBuilder = new StringBuilder();
            int stopIndex = -1;
            for (int i = 1; i < length; ++i) {
                char carac = line.charAt(i);
                if (carac == '\\' && i < length - 1) {
                    char next = line.charAt(i + 1);
                    if (next == '\\' || next == ':') {
                        sourceBuilder.append(next);
                    } else {
                        sourceBuilder.append('\\');
                        sourceBuilder.append(next);
                    }
                    ++i;
                    continue;
                }
                if (carac == ':') {
                    stopIndex = i;
                    break;
                }
                sourceBuilder.append(carac);
            }
            if (stopIndex != -1) {
                p.setSource(sourceBuilder.toString().trim());
                line = line.substring(stopIndex + 1).trim();
            }
        }
        textContentParser.parse(p, line);
        return p;
    }
}

