/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.tools.parsers.LineInfo;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.ficheblock.BlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.text.StringUtils;

class CodeParser
extends BlockParser {
    private final LineParser xmlLineParser = new XmlLineParser();
    private final LineParser scriptLineParser = new ScriptLineParser();
    private final LineParser defaultLineParser = new DefaultLineParser();
    private final TextContentParser textContentParser;
    private final boolean withLineNumber;

    CodeParser(TextContentParser textContentParser, boolean withLineNumber) {
        this.textContentParser = textContentParser;
        this.withLineNumber = withLineNumber;
    }

    @Override
    public boolean isStartLine(String line) {
        return line.startsWith("+++");
    }

    @Override
    public void parse(String[] lineArray, int startIndex, Atts initAtts) {
        String params;
        String firstLine = StringUtils.cleanString(lineArray[startIndex]);
        short type = 0;
        if (firstLine.length() > 3 && (params = firstLine.substring(3).trim()).length() > 0) {
            type = Code.typeToShort(params.charAt(0));
        }
        Code code = new Code(type);
        FicheUtils.populate(code, initAtts);
        LineParser lineParser = this.getLineParser(type);
        int beginIndex = BlockParser.parseZoneBlockElements(code, startIndex + 1, lineArray, this.textContentParser);
        int stop = lineArray.length - 1;
        int clearLineCount = -99999;
        for (int i = beginIndex; i <= stop; ++i) {
            String rawLine = lineArray[i];
            String line = StringUtils.cleanString(rawLine);
            if (line.startsWith("+++")) {
                stop = i;
                break;
            }
            LineInfo lineInfo = LineInfo.parse(line, this.withLineNumber ? i : -1);
            String cleanedLine = lineInfo.getCleanedLine();
            if (cleanedLine.length() > 0) {
                if (clearLineCount > 0) {
                    for (int j = 0; j < clearLineCount; ++j) {
                        code.add(new Ln(""));
                    }
                }
                clearLineCount = 0;
                Atts atts = lineInfo.getFirstAtts();
                if (atts != null && !atts.hasOnlyAutomaticAtts()) {
                    int idx = rawLine.indexOf(")]");
                    rawLine = rawLine.substring(idx + 2);
                }
                int indent = StringUtils.getIndent(rawLine);
                cleanedLine = this.testeDebut(cleanedLine);
                code.add(lineParser.parse(cleanedLine, indent, atts));
                continue;
            }
            ++clearLineCount;
        }
        this.setParseResult(stop, code);
    }

    private String testeDebut(String s) {
        if (s.charAt(0) == '\\' && s.length() > 1) {
            char carac2 = s.charAt(1);
            switch (carac2) {
                case '+': 
                case '[': 
                case '\\': {
                    s = s.substring(1);
                }
            }
        }
        return s;
    }

    private LineParser getLineParser(short type) {
        LineParser lineParser;
        switch (type) {
            case 1: {
                lineParser = this.xmlLineParser;
                break;
            }
            case 2: {
                lineParser = this.scriptLineParser;
                break;
            }
            default: {
                lineParser = this.defaultLineParser;
            }
        }
        lineParser.reinit();
        return lineParser;
    }

    private static Ln createLn(String line, int indentation, Atts atts) {
        Ln ln = new Ln(line, indentation);
        FicheUtils.populate(ln, atts);
        return ln;
    }

    private static class XmlLineParser
    extends LineParser {
        private XmlLineParser() {
        }

        @Override
        short getType() {
            return 1;
        }

        @Override
        Ln parse(String line, int rawIndent, Atts atts) {
            int ajout = 0;
            int length = line.length();
            for (int j = 0; j < length - 1; ++j) {
                char carac = line.charAt(j);
                char suivant = line.charAt(j + 1);
                if (!this.onComment) {
                    if (carac == '<') {
                        if (suivant == '/') {
                            --ajout;
                            continue;
                        }
                        if (suivant == '?') continue;
                        if (suivant == '!') {
                            this.onComment = true;
                            continue;
                        }
                        ++ajout;
                        continue;
                    }
                    if (carac != '/' || suivant != '>') continue;
                    --ajout;
                    continue;
                }
                if (carac != '-' || j >= length - 2 || suivant != '-' || line.charAt(j + 2) != '>') continue;
                this.onComment = false;
            }
            if (ajout < 0) {
                this.indent += ajout;
                if (this.indent < 0) {
                    this.indent = 0;
                }
            }
            Ln ln = CodeParser.createLn(line, this.indent, atts);
            if (ajout > 0) {
                this.indent += ajout;
            }
            return ln;
        }
    }

    private static abstract class LineParser {
        protected int indent = 0;
        protected boolean onComment = false;

        private LineParser() {
        }

        abstract short getType();

        void reinit() {
            this.indent = 0;
            this.onComment = false;
        }

        abstract Ln parse(String var1, int var2, Atts var3);
    }

    private static class ScriptLineParser
    extends LineParser {
        private ScriptLineParser() {
        }

        @Override
        short getType() {
            return 2;
        }

        @Override
        Ln parse(String line, int rawIndent, Atts atts) {
            boolean debut = true;
            int indentChange = 0;
            for (int j = 0; j < line.length(); ++j) {
                char carac = line.charAt(j);
                if (carac == '{') {
                    ++indentChange;
                    debut = false;
                    continue;
                }
                if (carac == '}') {
                    if (debut) {
                        --this.indent;
                        continue;
                    }
                    --indentChange;
                    continue;
                }
                if (carac == ' ') continue;
                debut = false;
            }
            Ln ln = CodeParser.createLn(line, Math.max(this.indent, 0), atts);
            this.indent += indentChange;
            if (this.indent < 0) {
                this.indent = 0;
            }
            return ln;
        }
    }

    private class DefaultLineParser
    extends LineParser {
        private DefaultLineParser() {
        }

        @Override
        short getType() {
            return 0;
        }

        @Override
        Ln parse(String line, int rawIndent, Atts atts) {
            return CodeParser.createLn(line, rawIndent, atts);
        }
    }
}

