/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.thesaurus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;

public class EditThesaurusImportBuilder
extends ThesaurusImportBuilder {
    private final List<BuilderInfo> builderList = new ArrayList<BuilderInfo>();
    private final Map<Integer, EditMotcleImportBuilder> creationByIdMap = new HashMap<Integer, EditMotcleImportBuilder>();
    private final Map<String, EditMotcleImportBuilder> creationByIdalphaMap = new HashMap<String, EditMotcleImportBuilder>();
    private final Map<Integer, EditMotcleImportBuilder> changeMap = new HashMap<Integer, EditMotcleImportBuilder>();

    public EditThesaurusImportBuilder(Thesaurus thesaurus) {
        super(thesaurus, "edit");
    }

    public EditMotcleImportBuilder getEditMotcleImportBuilder(int newId, String newIdalpha) {
        EditMotcleImportBuilder builder;
        if (newId > 0) {
            builder = this.creationByIdMap.get(newId);
            if (builder == null) {
                newIdalpha = this.testIdalpha(newIdalpha);
                builder = EditMotcleImportBuilder.init(newId);
                this.add(builder, true);
                this.creationByIdMap.put(newId, builder);
                if (newIdalpha != null) {
                    builder.setNewIdalpha(newIdalpha);
                    this.creationByIdalphaMap.put(newIdalpha, builder);
                }
            }
        } else if ((newIdalpha = this.testIdalpha(newIdalpha)) != null) {
            builder = this.creationByIdalphaMap.get(newIdalpha);
            if (builder == null) {
                builder = EditMotcleImportBuilder.init(-1).setNewIdalpha(newIdalpha);
                this.creationByIdalphaMap.put(newIdalpha, builder);
                this.add(builder, true);
            }
        } else {
            builder = EditMotcleImportBuilder.init(-1);
            this.add(builder, true);
        }
        return builder;
    }

    private String testIdalpha(String idalpha) {
        if (this.getThesaurus().isIdalphaType()) {
            if (idalpha == null) {
                throw new IllegalArgumentException("newIdalpha is null");
            }
            return idalpha;
        }
        return null;
    }

    public EditMotcleImportBuilder getEditMotcleImportBuilder(Motcle motcle) {
        int motcleId = motcle.getId();
        EditMotcleImportBuilder builder = this.changeMap.get(motcleId);
        if (builder == null) {
            builder = new EditMotcleImportBuilder(motcleId);
            this.changeMap.put(motcle.getId(), builder);
            this.add(builder, false);
        }
        return builder;
    }

    private void add(EditMotcleImportBuilder builder, boolean isCreation) {
        this.builderList.add(new BuilderInfo(builder, isCreation));
    }

    @Override
    protected List<ThesaurusImport.MotcleImport> getMotcleImportList() {
        ArrayList<ThesaurusImport.EditMotcleImport> finalList = new ArrayList<ThesaurusImport.EditMotcleImport>();
        for (BuilderInfo builderInfo : this.builderList) {
            ThesaurusImport.EditMotcleImport motcleImport = builderInfo.builder.toEditMotcleImport();
            if (!builderInfo.isCreation && EditThesaurusImportBuilder.isEmpty(motcleImport)) continue;
            finalList.add(motcleImport);
        }
        return ImportationUtils.wrap(finalList.toArray(new ThesaurusImport.MotcleImport[finalList.size()]));
    }

    public static EditThesaurusImportBuilder init(Thesaurus thesaurus) {
        return new EditThesaurusImportBuilder(thesaurus);
    }

    private static boolean isEmpty(ThesaurusImport.EditMotcleImport editMotcleImport) {
        if (editMotcleImport.getNewIdalpha() != null) {
            return false;
        }
        if (editMotcleImport.getParentChange() != null) {
            return false;
        }
        if (editMotcleImport.getNewStatus() != null) {
            return false;
        }
        if (!editMotcleImport.getLabelChange().isEmpty()) {
            return false;
        }
        if (!editMotcleImport.getAttributeChange().isEmpty()) {
            return false;
        }
        return editMotcleImport.getTiesImport().isEmpty();
    }

    private static class BuilderInfo {
        private final EditMotcleImportBuilder builder;
        private final boolean isCreation;

        private BuilderInfo(EditMotcleImportBuilder builder, boolean isCreation) {
            this.builder = builder;
            this.isCreation = isCreation;
        }
    }
}

