/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.tools.from.html.InlineConversion;
import net.fichotheque.tools.parsers.TextContentParser;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class ContentBuffer {
    private final List<Object> partList = new ArrayList<Object>();

    public boolean isEmpty() {
        return this.partList.isEmpty();
    }

    public int size() {
        return this.partList.size();
    }

    public boolean addPart(Object part) {
        if (part instanceof String) {
            return this.addText((String)part);
        }
        this.partList.add(part);
        return true;
    }

    public boolean isBrLast() {
        Object last;
        int size = this.partList.size();
        return size > 0 && (last = this.partList.get(size - 1)) instanceof S && ((S)last).getType() == 20;
    }

    public ContentBuffer add(List<Node> nodeList) {
        for (Node node : nodeList) {
            this.add(node);
        }
        return this;
    }

    public ContentBuffer add(Node node) {
        if (node instanceof TextNode) {
            this.addPart(((TextNode)node).text());
        } else if (node instanceof Element) {
            InlineConversion.convertInto((Element)node, this);
        }
        return this;
    }

    private boolean addText(String text) {
        if (text.isEmpty()) {
            return false;
        }
        int size = this.partList.size();
        if (size == 0) {
            if (!(text = text.replaceAll("^\\s+", "")).isEmpty()) {
                this.partList.add(text);
                return true;
            }
            return false;
        }
        Object previousPart = this.partList.get(size - 1);
        boolean add = true;
        if (text.trim().isEmpty()) {
            if (previousPart instanceof String) {
                String previousString = (String)previousPart;
                if (Character.isWhitespace(previousString.charAt(previousString.length() - 1))) {
                    add = false;
                }
            } else if (((S)previousPart).getType() == 20) {
                add = false;
            }
        }
        if (add) {
            this.partList.add(text);
            return true;
        }
        return false;
    }

    public void flush(TextContentBuilder textContentBuilder) {
        TextContentParser textContentParser = new TextContentParser();
        this.cleanLastBr();
        int size = this.partList.size();
        for (int i = 0; i < size; ++i) {
            Object part = this.partList.get(i);
            if (part instanceof String) {
                String partString = (String)part;
                if (i == size - 1) {
                    partString = partString.replaceAll("\\s+$", "");
                }
                textContentParser.parse(textContentBuilder, partString);
                continue;
            }
            if (!(part instanceof S)) continue;
            textContentBuilder.addS((S)part);
        }
    }

    private void cleanLastBr() {
        int size;
        if (this.isBrLast() && (size = this.partList.size()) > 1) {
            this.partList.remove(size - 1);
            this.cleanLastBr();
        }
    }

    public static ContentBuffer init() {
        return new ContentBuffer();
    }
}

