/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html;

import java.util.Collections;
import java.util.List;
import net.fichotheque.corpus.fiche.AttConsumer;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.tools.from.html.ContentBuffer;
import net.fichotheque.tools.from.html.TagUtils;
import net.fichotheque.tools.from.html.handlers.LiHandler;
import net.mapeadores.util.text.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public final class BlockConversion {
    private BlockConversion() {
    }

    public static void populate(Element element, ParagraphBlock paragraphBlock) {
        ContentBuffer.init().add(element.childNodes()).flush(paragraphBlock);
    }

    public static FicheBlock fromPre(Element element) {
        String[] lines;
        Code code = new Code(0);
        for (String line : lines = StringUtils.getLineTokens(element.wholeText(), (short)0)) {
            int indent = StringUtils.getIndent(line);
            code.add(new Ln(line, indent));
        }
        return code;
    }

    public static FicheBlock fromList(Element element, boolean ordered) {
        Ul ul = null;
        for (Element child : element.children()) {
            Li li = child.tagName().equals("li") ? BlockConversion.convertLi(child.childNodes()) : BlockConversion.convertLi(Collections.singletonList(child));
            if (li == null) continue;
            if (ul == null) {
                ul = new Ul(li);
                continue;
            }
            ul.add(li);
        }
        if (ul != null) {
            if (ordered) {
                ul.putAtt("variant", "ol");
                BlockConversion.addAttribute(element, ul, "type");
                BlockConversion.addAttribute(element, ul, "start");
                BlockConversion.addAttribute(element, ul, "reversed");
            }
            return ul;
        }
        return null;
    }

    public static FicheBlock fromTable(Element element) {
        Table table = new Table();
        for (Element child : element.children()) {
            switch (child.tagName()) {
                case "caption": {
                    ContentBuffer.init().add(child.childNodes()).flush(table.getLegendeBuilder());
                    break;
                }
                case "thead": 
                case "tbody": 
                case "tfoot": {
                    BlockConversion.convertTablePart(child, table);
                    break;
                }
                case "tr": {
                    BlockConversion.convertTr(child, table);
                }
            }
        }
        return table;
    }

    private static Li convertLi(List<Node> nodeList) {
        Li li;
        List<FicheBlock> ficheBlockList = LiHandler.INSTANCE.convertChildNodes(nodeList);
        int size = ficheBlockList.size();
        if (size == 0) {
            return null;
        }
        FicheBlock firstFicheBlock = ficheBlockList.get(0);
        if (firstFicheBlock instanceof P) {
            li = new Li((P)firstFicheBlock);
        } else {
            li = new Li(new P());
            li.add(firstFicheBlock);
        }
        for (int i = 1; i < size; ++i) {
            li.add(ficheBlockList.get(i));
        }
        return li;
    }

    private static void convertTablePart(Element tablePart, Table table) {
        for (Element child : tablePart.children()) {
            if (!child.tagName().equals("tr")) continue;
            BlockConversion.convertTr(child, table);
        }
    }

    private static void convertTr(Element row, Table table) {
        Tr tr = new Tr();
        for (Element child : row.children()) {
            Td td = null;
            switch (child.tagName()) {
                case "th": {
                    td = new Td(2);
                    break;
                }
                case "td": {
                    td = new Td();
                }
            }
            if (td == null) continue;
            ContentBuffer buf = new ContentBuffer();
            BlockConversion.flatBlocks(child, buf);
            buf.flush(td);
            tr.add(td);
        }
        table.add(tr);
    }

    private static void flatBlocks(Element parent, ContentBuffer contentBuffer) {
        boolean next = false;
        for (Node node : parent.childNodes()) {
            if (node instanceof TextNode) {
                boolean done = contentBuffer.addPart(((TextNode)node).text());
                if (!done) continue;
                next = true;
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            switch (TagUtils.getTagType(child)) {
                case 1: {
                    if (next) {
                        if (!contentBuffer.isBrLast()) {
                            contentBuffer.addPart(new S(20));
                        }
                    } else {
                        next = true;
                    }
                    BlockConversion.flatBlocks(child, contentBuffer);
                    break;
                }
                case 2: {
                    int previousSize = contentBuffer.size();
                    contentBuffer.add((Node)child);
                    if (contentBuffer.size() <= previousSize) break;
                    next = true;
                }
            }
        }
    }

    private static void addAttribute(Element element, AttConsumer attConsumer, String name) {
        String value = element.attr(name);
        if (!value.isEmpty()) {
            attConsumer.putAtt(name, value);
        }
    }
}

