/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.MotcleFormatter;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FormatterUtils;

public class MasterMotcleTokenizer
implements Tokenizer {
    private final Thesaurus thesaurus;
    private final MotcleFormatter motcleFormatter;
    private final boolean globalSelect;

    public MasterMotcleTokenizer(Thesaurus thesaurus, MotcleFormatter motcleFormatter, boolean globalSelect) {
        this.thesaurus = thesaurus;
        this.motcleFormatter = motcleFormatter;
        this.globalSelect = globalSelect;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        Predicate<SubsetItem> predicate;
        if (!formatSource.getSubsetAccessPredicate().test(this.thesaurus)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        Motcle motcle = this.thesaurus.getMotcleById(formatSource.getSubsetItemPointeur().getCurrentSubsetItem().getId());
        if (motcle != null && this.globalSelect && (predicate = formatSource.getGlobalPredicate()) != null && !predicate.test(motcle)) {
            motcle = null;
        }
        if (motcle == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(motcle, this.motcleFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final Motcle motcle;
        private final FormatSource formatSource;
        private final MotcleFormatter motcleFormatter;

        private InternalTokens(Motcle motcle, MotcleFormatter motcleFormatter, FormatSource formatSource) {
            this.motcle = motcle;
            this.motcleFormatter = motcleFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String get(int i) {
            return this.motcleFormatter.formatMotcle(this.motcle, 1, this.formatSource);
        }
    }
}

