/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.ValueFormatter;
import net.fichotheque.tools.format.FormatterEngineUtils;
import net.fichotheque.tools.format.catalogs.IdalphaFormatterCatalog;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class IdalphaFormatterParser {
    private IdalphaFormatterParser() {
    }

    public static ValueFormatter parse(String pattern, InstructionResolverProvider provider, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = "{value}";
        }
        try {
            return IdalphaFormatterParser.parse(pattern, provider);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static ValueFormatter parse(String pattern, InstructionResolverProvider provider) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(provider), pattern);
        return new InternalIdalphaFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;

        private InternalInstructionResolver(InstructionResolverProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(ValueFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return IdalphaFormatterCatalog.VALUE;
                }
                case "significant": {
                    return IdalphaFormatterCatalog.SIGNIFICANT;
                }
                case "value": {
                    boolean up = FormatterEngineUtils.isUppercase(instruction);
                    if (up) {
                        return IdalphaFormatterCatalog.VALUE_UP;
                    }
                    return IdalphaFormatterCatalog.VALUE;
                }
            }
            return null;
        }
    }

    private static class InternalIdalphaFormatter
    implements ValueFormatter {
        private final Object[] partArray;

        private InternalIdalphaFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatValue(String value, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                ValueFormatter formatter = (ValueFormatter)obj;
                buf.append(formatter.formatValue(value, formatSource));
            }
            return buf.toString();
        }
    }
}

