/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import java.io.IOException;
import net.fichotheque.utils.SyntaxUtils;
import net.mapeadores.util.text.StringUtils;

public final class JavaResolver {
    public static final int INTERFACE = 1;
    public static final int CLASS = 2;

    private JavaResolver() {
    }

    public static String resolve(String value, int type) {
        if (value.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        try {
            JavaResolver.resolve(buf, value, type);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void resolve(Appendable appendable, String value, int type) throws IOException {
        String[] tokens = StringUtils.getTokens(value, '.', (short)0);
        int last = tokens.length - 1;
        for (int i = 0; i < last; ++i) {
            SyntaxUtils.appendSpan(appendable, "cm-java-package", tokens[i]);
            SyntaxUtils.appendSpan(appendable, "cm-punctuation", ".");
        }
        SyntaxUtils.appendSpan(appendable, JavaResolver.getCssClass(type), tokens[last]);
    }

    public static String getCssClass(int value) {
        switch (value) {
            case 1: {
                return "cm-java-interface";
            }
            case 2: {
                return "cm-java-class";
            }
        }
        return "";
    }
}

