/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction;

import java.text.ParseException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.extraction.def.GroupParams;
import net.fichotheque.extraction.run.FicheItemGroupParams;
import net.fichotheque.extraction.run.FieldsGroupParams;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.text.StringUtils;

public class GroupParamsParser {
    private static final String ALPHABET_MODE = "alphabet";
    private static final String MODE_KEY = "mode";
    private static final String FIELDS_KEY = "fields";
    private static final String FIELD_KEY = "field";

    public static GroupParams parse(String groupType, String paramsString) {
        Instruction instruction = InstructionParser.parse(paramsString, null);
        if (instruction == null) {
            return null;
        }
        switch (groupType) {
            case "weight": 
            case "position": {
                return null;
            }
            case "title": {
                return GroupParamsParser.parseTitreGroupParams(instruction);
            }
            case "year": 
            case "lang": 
            case "country": {
                return GroupParamsParser.parseFicheItemGroupParams(instruction);
            }
            case "fields": {
                return GroupParamsParser.parseFieldsGroupParams(instruction);
            }
        }
        return null;
    }

    public static FieldsGroupParams parseFieldsGroupParams(Instruction instruction) {
        return GroupParamsParser.internalParseFieldsGroupParams(instruction, true);
    }

    public static FieldsGroupParams parseTitreGroupParams(Instruction instruction) {
        return GroupParamsParser.internalParseFieldsGroupParams(instruction, false);
    }

    public static FicheItemGroupParams parseFicheItemGroupParams(Instruction instruction) {
        FieldKey fieldKey = null;
        for (Argument argument : instruction) {
            String key = argument.getKey();
            String value = argument.getNotNullValue();
            if (key.equals(FIELD_KEY)) {
                try {
                    fieldKey = FieldKey.parse(value);
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (!value.isEmpty()) continue;
            try {
                fieldKey = FieldKey.parse(key);
            }
            catch (ParseException parseException) {}
        }
        if (fieldKey == null) {
            return null;
        }
        if (!GroupParamsParser.isValidFicheItemField(fieldKey)) {
            return null;
        }
        return new InternalFicheItemGroupParams(fieldKey);
    }

    private static boolean isValidFicheItemField(FieldKey fieldKey) {
        switch (fieldKey.getCategory()) {
            case 1: 
            case 2: {
                return true;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "lang": {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static FieldsGroupParams internalParseFieldsGroupParams(Instruction instruction, boolean testFields) {
        short mode = 0;
        FieldKey[] fieldKeyArray = null;
        for (Argument argument : instruction) {
            String key = argument.getKey();
            String value = argument.getNotNullValue();
            if (key.equals(ALPHABET_MODE)) {
                mode = 1;
                continue;
            }
            if (key.equals(MODE_KEY)) {
                if (!value.equals(ALPHABET_MODE)) continue;
                mode = 1;
                continue;
            }
            if (!key.equals(FIELDS_KEY) || !testFields) continue;
            fieldKeyArray = GroupParamsParser.parseFieldArray(value);
        }
        if (!testFields) {
            fieldKeyArray = new FieldKey[]{FieldKey.TITLE};
        }
        if (fieldKeyArray == null) {
            return null;
        }
        return new InternalFieldsGroupParams(mode, fieldKeyArray);
    }

    private static FieldKey[] parseFieldArray(String s) {
        String[] tokenArray = StringUtils.getTechnicalTokens(s, true);
        int length = tokenArray.length;
        if (length == 0) {
            return null;
        }
        FieldKey[] fieldArray = new FieldKey[length];
        for (int i = 0; i < length; ++i) {
            try {
                FieldKey fieldKey = FieldKey.parse(tokenArray[i]);
                if (!GroupParamsParser.testFieldKey(fieldKey)) {
                    return null;
                }
                fieldArray[i] = fieldKey;
                continue;
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return fieldArray;
    }

    private static boolean testFieldKey(FieldKey fieldKey) {
        switch (fieldKey.getCategory()) {
            case 1: 
            case 2: {
                return true;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "title": 
                    case "subtitle": {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static class InternalFicheItemGroupParams
    implements FicheItemGroupParams {
        private final FieldKey fieldKey;

        InternalFicheItemGroupParams(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }

        @Override
        public String toString() {
            return "field=" + this.fieldKey.getKeyString();
        }
    }

    private static class InternalFieldsGroupParams
    implements FieldsGroupParams {
        private final short mode;
        private final FieldKey[] fieldKeyArray;

        InternalFieldsGroupParams(short mode, FieldKey[] fieldKeyArray) {
            this.mode = mode;
            this.fieldKeyArray = fieldKeyArray;
        }

        @Override
        public short getMode() {
            return this.mode;
        }

        @Override
        public FieldKey[] getFieldKeyArray() {
            return this.fieldKeyArray;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(GroupParamsParser.FIELDS_KEY);
            buf.append('=');
            int length = this.fieldKeyArray.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(" ");
                }
                buf.append(this.fieldKeyArray[i].getKeyString());
            }
            if (this.mode != 0) {
                buf.append(',');
                buf.append(GroupParamsParser.MODE_KEY);
                buf.append('=');
                buf.append(1);
            }
            return buf.toString();
        }
    }
}

