/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.FormatColDefChecker;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableDefItem;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.exportation.table.TableParameterDef;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.tools.format.FichothequeFormatDefParser;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;

public class TableDefParser {
    private static final short START_BLOCK = 1;
    private static final short ON_BLOCK = 2;
    private static final short ON_PARAMETER = 3;
    private static final String START_PREFIX = "!!start ";
    private static final String END_PREFIX = "!!end";
    private final List<TableDefItem> defItemList = new ArrayList<TableDefItem>();
    private final LineMessageHandler lineMessageHandler;
    private final FormatColDefChecker formatColDefChecker;
    private final TableExportContext tableExportContext;
    private final Subset subset;
    private String currentColLine = null;
    private String currentFormatSource = null;
    private String currentFormatPattern = null;
    private String currentFormatInstruction = null;
    private final List<String> inclusionLineList = new ArrayList<String>();
    private String currentParameter = null;
    private StringBuilder currentParameterBuilder = null;
    private int firstLineNumber;
    private boolean ficheFormatLine = false;
    private short state = 1;

    private TableDefParser(Subset subset, TableExportContext tableExportContext, LineMessageHandler lineMessageHandler) {
        this.subset = subset;
        this.tableExportContext = tableExportContext;
        this.lineMessageHandler = lineMessageHandler;
        this.formatColDefChecker = tableExportContext != null ? tableExportContext.getFormatColDefChecker(subset) : null;
    }

    public static TableDef parse(Reader reader, Subset subset, TableExportContext tableExportContext, LineMessageHandler lineMessageHandler, int lineDiff) throws IOException {
        String line;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        TableDefParser tableDefParser = new TableDefParser(subset, tableExportContext, lineMessageHandler);
        while ((line = lineNumberReader.readLine()) != null) {
            int lineNumber = lineNumberReader.getLineNumber() + lineDiff;
            tableDefParser.parseLine(line, lineNumber);
        }
        tableDefParser.flush();
        tableDefParser.flushParameter();
        return TableDefUtils.toTableDef(tableDefParser.defItemList);
    }

    public static TableDef parse(String s, Subset subset, TableExportContext tableExportContext, LineMessageHandler lineMessageHandler, int lineDif) {
        try {
            StringReader reader = new StringReader(s);
            return TableDefParser.parse(reader, subset, tableExportContext, lineMessageHandler, 0);
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException();
        }
    }

    public static TableDef parse(String s, LineMessageHandler lineMessageHandler, int lineDif) {
        try {
            StringReader reader = new StringReader(s);
            return TableDefParser.parse(reader, null, null, lineMessageHandler, 0);
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException();
        }
    }

    private void parseLine(String line, int lineNumber) {
        if ((line = line.trim()).length() == 0) {
            switch (this.state) {
                case 2: {
                    this.flush();
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.currentParameterBuilder.append('\n');
                    break;
                }
                default: {
                    this.state = 1;
                }
            }
            return;
        }
        char carac = line.charAt(0);
        if (carac == '#') {
            return;
        }
        if (carac == '!') {
            switch (this.state) {
                case 1: {
                    if (line.startsWith(START_PREFIX)) {
                        this.currentParameter = line.substring(START_PREFIX.length()).trim();
                        if (this.currentParameter.length() == 0) {
                            this.lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.empty.tableexport.parametername", new Object[0]);
                            this.currentParameter = null;
                            return;
                        }
                        this.currentParameterBuilder = new StringBuilder();
                        this.state = (short)3;
                        break;
                    }
                    this.addParameter(line, lineNumber);
                    break;
                }
                case 2: {
                    this.addLine(line, lineNumber);
                    break;
                }
                case 3: {
                    if (line.startsWith(END_PREFIX)) {
                        this.state = 1;
                        this.flushParameter();
                        break;
                    }
                    this.currentParameterBuilder.append(line);
                    this.currentParameterBuilder.append('\n');
                }
            }
            return;
        }
        switch (this.state) {
            case 1: 
            case 2: {
                this.addLine(line, lineNumber);
                this.state = (short)2;
                break;
            }
            case 3: {
                this.currentParameterBuilder.append(line);
                this.currentParameterBuilder.append('\n');
            }
        }
    }

    private void addParameter(String line, int currentLineNumber) {
        if (line.length() == 1) {
            this.lineMessageHandler.addMessage("severe.format.syntax", currentLineNumber, "_ error.empty.tableexport.parameterline", new Object[0]);
            return;
        }
        int idx = line.indexOf(61);
        if (idx == -1) {
            this.lineMessageHandler.addMessage("severe.format.syntax", currentLineNumber, "_ error.empty.tableexport.parametervalue", line);
            return;
        }
        String paramName = line.substring(1, idx).trim();
        if (paramName.length() == 0) {
            this.lineMessageHandler.addMessage("severe.format.syntax", currentLineNumber, "_ error.empty.tableexport.parametername", line);
            return;
        }
        if (paramName.charAt(0) == '!') {
            this.lineMessageHandler.addMessage("severe.format.syntax", currentLineNumber, "_ error.wrong.tableexport.parametername", line);
            return;
        }
        String paramValue = line.substring(idx + 1).trim();
        this.addParameter(paramName, paramValue);
    }

    private void addLine(String line, int currentLineNumber) {
        if (this.currentColLine == null) {
            this.firstLineNumber = currentLineNumber;
            if (line.startsWith("%")) {
                line = line.length() == 1 ? "NULL" : line.substring(1);
                this.ficheFormatLine = false;
            } else {
                this.ficheFormatLine = true;
            }
            this.currentColLine = line;
        } else if (this.ficheFormatLine) {
            if (this.currentFormatSource == null) {
                this.currentFormatSource = line;
            } else if (this.currentFormatPattern == null) {
                this.currentFormatPattern = line;
            } else if (this.currentFormatInstruction == null) {
                this.currentFormatInstruction = line;
            } else {
                this.lineMessageHandler.addMessage("warning.format.syntax", currentLineNumber, "_ error.wrong.tableexport.toomanylines", line);
            }
        } else {
            this.inclusionLineList.add(line);
        }
    }

    private void flushParameter() {
        if (this.currentParameter != null) {
            this.addParameter(this.currentParameter, this.currentParameterBuilder.toString());
        }
        this.currentParameter = null;
        this.currentParameterBuilder = null;
    }

    private void flush() {
        if (this.currentColLine != null) {
            Labels customLabels;
            String colName;
            int idx = this.currentColLine.indexOf(62);
            if (idx > 0) {
                colName = this.currentColLine.substring(0, idx).trim();
                String instruction = this.currentColLine.substring(idx + 1);
                try {
                    customLabels = LabelUtils.parseInstruction(instruction);
                }
                catch (ParseException pe) {
                    customLabels = null;
                }
            } else {
                colName = this.currentColLine;
                customLabels = null;
            }
            if (this.ficheFormatLine) {
                FichothequeFormatDef formatDef;
                if (this.currentFormatSource == null) {
                    this.lineMessageHandler.addMessage("severe.format.syntax", this.firstLineNumber + 2, "_ error.empty.tableexport.formatsourceline", new Object[0]);
                    this.clear();
                    return;
                }
                if (this.currentFormatPattern != null && this.currentFormatPattern.equals("-")) {
                    this.currentFormatPattern = null;
                }
                if ((formatDef = FichothequeFormatDefParser.parse(this.currentFormatSource, this.currentFormatPattern, this.currentFormatInstruction, TableDefUtils.toFormatDefMessageHandler(this.lineMessageHandler, this.firstLineNumber))) != null && (this.formatColDefChecker == null || this.formatColDefChecker.checkFormatColDef(colName, formatDef, this.firstLineNumber, this.lineMessageHandler))) {
                    FormatColDef colDef = TableDefUtils.toFormatColDef(colName, formatDef, customLabels);
                    this.addDefItem(this.firstLineNumber, colDef);
                }
            } else {
                TableInclusionDef tableInclusionDef = TableDefUtils.newTableInclusionDef(colName, customLabels, this.inclusionLineList.toArray(new String[this.inclusionLineList.size()]));
                if (this.checkTableInclusionDef(this.firstLineNumber, tableInclusionDef)) {
                    this.addDefItem(this.firstLineNumber, tableInclusionDef);
                }
            }
            this.clear();
        }
    }

    private boolean checkTableInclusionDef(int lineNumber, TableInclusionDef tableInclusionDef) {
        if (this.tableExportContext == null) {
            return true;
        }
        TableInclusionResolver tableInclusionResolver = this.tableExportContext.getTableInclusionResolverProvider().getTableInclusionResolver(tableInclusionDef.getNameSpace());
        if (tableInclusionResolver == null) {
            this.lineMessageHandler.addMessage("warning.format.fichotheque", lineNumber, "_ error.unknown.tableexport.inclusion", tableInclusionDef.getNameSpace());
            return false;
        }
        return tableInclusionResolver.test(tableInclusionDef, this.subset, this.tableExportContext, lineNumber, this.lineMessageHandler);
    }

    private void clear() {
        this.currentColLine = null;
        this.currentFormatSource = null;
        this.currentFormatPattern = null;
        this.currentFormatInstruction = null;
        this.inclusionLineList.clear();
    }

    private void addParameter(String paramName, String paramValue) {
        this.defItemList.add(new InternalTableParameterDef(paramName, paramValue));
    }

    private void addDefItem(int lineNumber, TableDefItem defItem) {
        this.defItemList.add(defItem);
    }

    private static class InternalTableParameterDef
    implements TableParameterDef {
        private final String parameterName;
        private final String parameterValue;

        private InternalTableParameterDef(String parameterName, String parameterValue) {
            this.parameterName = parameterName;
            this.parameterValue = parameterValue;
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getParameterValue() {
            return this.parameterValue;
        }
    }
}

