/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.tools.exportation.balayage.BalayageDefBuilder;
import net.fichotheque.tools.exportation.balayage.BalayageOutputBuilder;
import net.fichotheque.tools.exportation.balayage.BalayageUnitBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BalayageUnitDOMReader {
    private final Fichotheque fichotheque;
    private final BalayageDefBuilder balayageDefBuilder;
    private final MessageHandler messageHandler;

    public BalayageUnitDOMReader(Fichotheque fichotheque, BalayageDefBuilder balayageDefBuilder, MessageHandler messageHandler) {
        this.fichotheque = fichotheque;
        this.balayageDefBuilder = balayageDefBuilder;
        this.messageHandler = messageHandler;
    }

    public BalayageUnitDOMReader read(Element element) {
        switch (element.getTagName()) {
            case "corpus-balayage": {
                this.addCorpusBalayageUnit(element);
                break;
            }
            case "fiche-balayage": {
                this.addFicheBalayageUnit(element);
                break;
            }
            case "thesaurus-balayage": {
                this.addThesaurusBalayageUnit(element);
                break;
            }
            case "motcle-balayage": {
                this.addMotcleBalayageUnit(element);
                break;
            }
            case "unique-balayage": {
                this.addUniqueBalayageUnit(element);
                break;
            }
            case "document-balayage": {
                this.addDocumentBalayageUnit(element);
                break;
            }
            case "illustration-balayage": {
                this.addIllustrationBalayageUnit(element);
            }
        }
        return this;
    }

    private void addCorpusBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("corpus");
        this.commonBalayageUnit(balayageUnitBuilder, element);
        balayageUnitBuilder.setFicheQuery(SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element).getFicheQuery());
    }

    private void addFicheBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("fiche");
        this.commonBalayageUnit(balayageUnitBuilder, element);
        balayageUnitBuilder.setFicheQuery(SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element).getFicheQuery());
    }

    private void addThesaurusBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("thesaurus");
        this.commonBalayageUnit(balayageUnitBuilder, element);
        balayageUnitBuilder.setMotcleQuery(SelectionDOMUtils.getMotcleConditionEntry(this.fichotheque, element).getMotcleQuery());
    }

    private void addMotcleBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("motcle");
        this.commonBalayageUnit(balayageUnitBuilder, element);
        balayageUnitBuilder.setMotcleQuery(SelectionDOMUtils.getMotcleConditionEntry(this.fichotheque, element).getMotcleQuery());
    }

    private void addUniqueBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("unique");
        this.commonBalayageUnit(balayageUnitBuilder, element);
    }

    private void addDocumentBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("document");
        this.commonBalayageUnit(balayageUnitBuilder, element);
        balayageUnitBuilder.setFicheQuery(SelectionDOMUtils.getFicheConditionEntry(this.fichotheque, element).getFicheQuery()).setDocumentQuery(SelectionDOMUtils.getDocumentConditionEntry(element).getDocumentQuery());
        DOMUtils.readChildren(element, new ExtensionConsumer(balayageUnitBuilder));
    }

    private void addIllustrationBalayageUnit(Element element) {
        BalayageUnitBuilder balayageUnitBuilder = this.balayageDefBuilder.addBalayageUnitBuilder("illustration");
        this.commonBalayageUnit(balayageUnitBuilder, element);
        balayageUnitBuilder.setIllustrationQuery(SelectionDOMUtils.getIllustrationConditionEntry(element).getIllustrationQuery());
    }

    private void commonBalayageUnit(BalayageUnitBuilder balayageUnitBuilder, Element element) {
        String[] tokens;
        balayageUnitBuilder.setName(element.getAttribute("name")).setExtractionPath(element.getAttribute("extraction"));
        String globalselect = element.getAttribute("global-select");
        if (globalselect.equals("false")) {
            balayageUnitBuilder.setGlobalSelect(false);
        }
        DOMUtils.readChildren(element, new OutputConsumer(balayageUnitBuilder));
        String mode = element.getAttribute("mode");
        for (String token : tokens = StringUtils.getTechnicalTokens(mode, true)) {
            balayageUnitBuilder.addMode(token);
        }
    }

    public BalayageUnitDOMReader init(Fichotheque fichotheque, BalayageDefBuilder balayageDefBuilder, MessageHandler messageHandler) {
        return new BalayageUnitDOMReader(fichotheque, balayageDefBuilder, messageHandler);
    }

    private static String normalizePath(String path) {
        int length = path.length();
        if (length == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return BalayageUnitDOMReader.normalizePath(path.substring(1));
        }
        char lastChar = path.charAt(length - 1);
        if (lastChar != '/') {
            path = path + '/';
        }
        return path;
    }

    private class ExtensionConsumer
    implements Consumer<Element> {
        private final BalayageUnitBuilder balayageUnitBuilder;

        private ExtensionConsumer(BalayageUnitBuilder balayageUnitBuilder) {
            this.balayageUnitBuilder = balayageUnitBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "extension": {
                    String extension = XMLUtils.getData(element);
                    if (extension.length() <= 0) break;
                    this.balayageUnitBuilder.addExtension(extension);
                }
            }
        }
    }

    private class OutputConsumer
    implements Consumer<Element> {
        private final BalayageUnitBuilder balayageUnitBuilder;

        private OutputConsumer(BalayageUnitBuilder balayageUnitBuilder) {
            this.balayageUnitBuilder = balayageUnitBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "output": {
                    BalayageOutputBuilder outputBuilder = this.balayageUnitBuilder.addOutputBuilder();
                    this.parseOutput(element, outputBuilder);
                }
            }
        }

        private void parseOutput(Element element, BalayageOutputBuilder outputBuilder) {
            String path;
            Langs langs;
            String langsValue;
            outputBuilder.setName(element.getAttribute("name")).setXsltPath(element.getAttribute("xslt")).setMode(element.getAttribute("mode")).setPosttransform(element.getAttribute("posttransform")).setCleanBefore(StringUtils.isTrue(element.getAttribute("clean")));
            String patternString = element.getAttribute("pattern");
            if (patternString.length() > 0) {
                try {
                    AccoladePattern pattern = new AccoladePattern(patternString);
                    outputBuilder.setPattern(pattern);
                }
                catch (ParseException pattern) {
                    // empty catch block
                }
            }
            if ((langsValue = element.getAttribute("langs")).length() > 0 && !(langs = LangsUtils.toCleanLangs(langsValue)).isEmpty()) {
                outputBuilder.setCustomLangs(langs);
            }
            if ((path = BalayageUnitDOMReader.normalizePath(element.getAttribute("path"))) != null) {
                if (path.equals("_inc_/")) {
                    outputBuilder.setIncludeOutput(true);
                } else {
                    outputBuilder.setIncludeOutput(false);
                    try {
                        AccoladePattern outputPathPattern = new AccoladePattern(path);
                        outputBuilder.setOutputPathPattern(outputPathPattern);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            try {
                outputBuilder.setLangOption(element.getAttribute("lang-option"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            DOMUtils.readChildren(element, new ParamConsumer(outputBuilder));
        }
    }

    private class ParamConsumer
    implements Consumer<Element> {
        private final BalayageOutputBuilder outputBuilder;

        private ParamConsumer(BalayageOutputBuilder outputBuilder) {
            this.outputBuilder = outputBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "param": {
                    String name = element.getAttribute("name");
                    if (name.length() <= 0) break;
                    String value = element.getAttribute("value");
                    this.outputBuilder.addOutputParam(name, value);
                }
            }
        }
    }
}

