/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.util.function.Consumer;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.Illustration;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class IllustrationDOMReader {
    private final MessageHandler messageHandler;
    private final AlbumEditor albumEditor;
    private final RootConsumer rootConsumer = new RootConsumer();

    public IllustrationDOMReader(AlbumEditor albumEditor, MessageHandler messageHandler) {
        this.albumEditor = albumEditor;
        this.messageHandler = messageHandler;
    }

    public void fillIllustration(Illustration illustration, Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        this.rootConsumer.setIllustration(illustration, attributesBuilder);
        DOMUtils.readChildren(element, this.rootConsumer);
        this.albumEditor.getFichothequeEditor().putAttributes(illustration, attributesBuilder.toAttributes());
    }

    private class RootConsumer
    implements Consumer<Element> {
        private Illustration illustration;
        private AttributesBuilder attributesBuilder;

        private RootConsumer() {
        }

        private void setIllustration(Illustration illustration, AttributesBuilder attributesBuilder) {
            this.illustration = illustration;
            this.attributesBuilder = attributesBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("attr")) {
                AttributeUtils.readAttrElement(this.attributesBuilder, element, IllustrationDOMReader.this.messageHandler, tagName);
            } else {
                DomMessages.unknownTagWarning(IllustrationDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

