/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.alias;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.alias.AliasHolderBuilder;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class AliasDOMReader {
    private final AliasHolderBuilder builder;
    private final Map<String, SubsetKey> corpusKeyMap = new HashMap<String, SubsetKey>();
    private final Map<String, SubsetKey> thesaurusKeyMap = new HashMap<String, SubsetKey>();
    private final Map<String, FieldKey> fieldKeyMap = new HashMap<String, FieldKey>();

    public AliasDOMReader(AliasHolderBuilder builder) {
        this.builder = builder;
    }

    public void readAlias(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
    }

    public SubsetKey getCorpusKey(String alias) {
        return this.corpusKeyMap.get(alias);
    }

    public SubsetKey getThesaurusKey(String alias) {
        return this.thesaurusKeyMap.get(alias);
    }

    public FieldKey getFieldKey(String alias) {
        return this.fieldKeyMap.get(alias);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String alias = element.getAttribute("alias");
            if (alias.length() == 0) {
                return;
            }
            String name = element.getAttribute("name");
            if (tagName.equals("corpus")) {
                SubsetKey subsetKey;
                if (name.length() == 0) {
                    return;
                }
                try {
                    subsetKey = SubsetKey.parse((short)1, name);
                }
                catch (ParseException pe) {
                    return;
                }
                AliasDOMReader.this.corpusKeyMap.put(alias, subsetKey);
                if (AliasDOMReader.this.builder != null) {
                    Corpus corpus = AliasDOMReader.this.builder.initCorpus(alias, subsetKey);
                    if (corpus != null) {
                        DOMUtils.readChildren(element, new CorpusConsumer(corpus, alias));
                    }
                } else {
                    DOMUtils.readChildren(element, new CorpusConsumer(null, alias));
                }
            } else if (tagName.equals("thesaurus")) {
                SubsetKey subsetKey;
                if (name.length() == 0) {
                    return;
                }
                try {
                    subsetKey = SubsetKey.parse((short)2, name);
                }
                catch (ParseException pe) {
                    return;
                }
                AliasDOMReader.this.thesaurusKeyMap.put(alias, subsetKey);
                if (AliasDOMReader.this.builder != null) {
                    AliasDOMReader.this.builder.initThesaurus(alias, subsetKey);
                }
            } else if (tagName.equals("core-corpus")) {
                if (AliasDOMReader.this.builder != null) {
                    Corpus coreCorpus = AliasDOMReader.this.builder.getCoreCorpus(alias);
                    if (coreCorpus != null) {
                        DOMUtils.readChildren(element, new CorpusConsumer(coreCorpus, alias));
                    }
                } else {
                    DOMUtils.readChildren(element, new CorpusConsumer(null, alias));
                }
            }
        }
    }

    private class CorpusConsumer
    implements Consumer<Element> {
        private final Corpus corpus;
        private final String corpusAlias;

        private CorpusConsumer(Corpus corpus, String corpusAlias) {
            this.corpus = corpus;
            this.corpusAlias = corpusAlias;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String alias = element.getAttribute("alias");
            if (alias.length() == 0) {
                return;
            }
            if (tagName.equals("field")) {
                FieldKey fieldKey;
                String key = element.getAttribute("key");
                if (key.length() == 0) {
                    return;
                }
                try {
                    fieldKey = FieldKey.parse(key);
                }
                catch (ParseException pe) {
                    return;
                }
                AliasDOMReader.this.fieldKeyMap.put(alias, fieldKey);
                if (AliasDOMReader.this.builder != null) {
                    AliasDOMReader.this.builder.initField(this.corpus, this.corpusAlias, alias, fieldKey);
                }
            }
        }
    }
}

