/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools;

import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.UserLoginException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.annotation.Nullable;

public class DefaultFichothequeQuestioner
implements FichothequeQuestioner {
    private final Fichotheque fichotheque;

    public DefaultFichothequeQuestioner(Fichotheque fichotheque) {
        this.fichotheque = fichotheque;
    }

    @Override
    public SubsetItem parseGlobalId(String globalId, short subsetCategory, @Nullable Subset defaultSubset) throws ParseException {
        int id;
        Subset subset;
        int idx = globalId.indexOf(47);
        if (idx == 0) {
            if (globalId.length() == 1) {
                throw new ParseException(globalId, 0);
            }
            idx = -1;
            globalId = globalId.substring(1);
        }
        if (idx == -1) {
            if (defaultSubset == null) {
                throw new ParseException(globalId, 0);
            }
            subset = defaultSubset;
            try {
                id = Integer.parseInt(globalId);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(globalId, 0);
            }
        }
        if (idx == globalId.length() - 1) {
            throw new ParseException(globalId, 0);
        }
        String subsetName = globalId.substring(0, idx);
        SubsetKey subsetKey = SubsetKey.parse(subsetCategory, subsetName);
        subset = this.fichotheque.getSubset(subsetKey);
        if (subset == null) {
            throw new ParseException(globalId, 0);
        }
        try {
            id = Integer.parseInt(globalId.substring(idx + 1));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(globalId, idx);
        }
        if (id < 0) {
            throw new ParseException(globalId, 0);
        }
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw new ParseException(globalId, 0);
        }
        return subsetItem;
    }

    @Override
    public Redacteur getRedacteurByLogin(String key, @Nullable SubsetKey defaultSphereKey) throws UserLoginException {
        try {
            LoginKey loginKey = LoginKey.parse(key);
            Sphere sphere = (Sphere)this.fichotheque.getSubset(loginKey.getSphereKey());
            if (sphere == null) {
                throw new UserLoginException("unknown_sphere");
            }
            Redacteur redacteur = sphere.getRedacteurByLogin(loginKey.getLogin());
            if (redacteur == null) {
                throw new UserLoginException("unknown_login");
            }
            return redacteur;
        }
        catch (ParseException loginKey) {
            int idx = key.indexOf(47);
            if (idx != -1) {
                Redacteur redacteur = this.getRedacteurByGlobalId(key);
                if (redacteur != null) {
                    return redacteur;
                }
                throw new UserLoginException("malformed_key");
            }
            if (defaultSphereKey == null) {
                throw new UserLoginException("malformed_key");
            }
            Sphere defaultSphere = (Sphere)this.fichotheque.getSubset(defaultSphereKey);
            if (defaultSphere == null) {
                throw new UserLoginException("unknown_sphere");
            }
            Redacteur redacteur = defaultSphere.getRedacteurByLogin(key);
            if (redacteur == null) {
                throw new UserLoginException("unknown_login");
            }
            return redacteur;
        }
    }

    @Override
    public Motcle parseGlobalIdalpha(String globalIdalpha) throws ParseException {
        int idx = globalIdalpha.indexOf(33);
        if (idx == -1) {
            throw new ParseException(globalIdalpha, 0);
        }
        String subsetName = globalIdalpha.substring(0, idx);
        SubsetKey subsetKey = SubsetKey.parse((short)2, subsetName);
        Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(subsetKey);
        if (thesaurus == null) {
            throw new ParseException(globalIdalpha, 0);
        }
        Motcle motcle = thesaurus.getMotcleByIdalpha(globalIdalpha.substring(idx + 1));
        if (motcle == null) {
            throw new ParseException(globalIdalpha, 0);
        }
        return motcle;
    }

    @Override
    public Version parseVersionKey(String versionKey) throws ParseException {
        int documentid;
        int idx = versionKey.indexOf(47);
        if (idx == -1) {
            throw new ParseException("mising / character: " + versionKey, 0);
        }
        SubsetKey addendaKey = SubsetKey.parse((short)4, versionKey.substring(0, idx));
        Addenda addenda = (Addenda)this.fichotheque.getSubset(addendaKey);
        if (addenda == null) {
            throw new ParseException("unknown addenda: " + versionKey, 0);
        }
        int idx2 = versionKey.indexOf(46);
        if (idx2 == -1) {
            throw new ParseException("mising . character: " + versionKey, idx + 1);
        }
        try {
            documentid = Integer.parseInt(versionKey.substring(idx + 1, idx2));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("documentid not integer: " + versionKey, idx + 1);
        }
        Document document = addenda.getDocumentById(documentid);
        if (document == null) {
            throw new ParseException("unknwon documentid: " + versionKey, idx + 1);
        }
        Version version = document.getVersionByExtension(versionKey.substring(idx2 + 1));
        if (version == null) {
            throw new ParseException("unknwon extension: " + versionKey, idx2 + 1);
        }
        return version;
    }
}

