/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.impl.AbstractMotcle;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.ThesaurusUtils;

class Motcles {
    private final List<AbstractMotcle> list = new ArrayList<AbstractMotcle>();
    private List<Motcle> cacheList = null;

    Motcles() {
    }

    int size() {
        return this.list.size();
    }

    List<Motcle> getCache() {
        List<Motcle> result = this.cacheList;
        if (result == null) {
            result = this.initCache();
        }
        return result;
    }

    synchronized void remove(int index) {
        this.list.remove(index);
        int size = this.list.size();
        for (int i = index; i < size; ++i) {
            AbstractMotcle motcle = this.list.get(i);
            motcle.decreaseIndex();
        }
        this.clearCache();
    }

    synchronized void add(AbstractMotcle motcle) {
        int size = this.list.size();
        this.list.add(motcle);
        motcle.setChildIndex(size);
        this.clearCache();
    }

    synchronized void permute(int oldIndex, int newIndex) {
        if (newIndex < 0 || newIndex >= this.list.size()) {
            throw new IndexOutOfBoundsException();
        }
        AbstractMotcle movedMotcle = this.list.set(newIndex, this.list.get(oldIndex));
        if (oldIndex > newIndex) {
            for (int i = newIndex + 1; i <= oldIndex; ++i) {
                movedMotcle.setChildIndex(i);
                movedMotcle = this.list.set(i, movedMotcle);
            }
        } else {
            for (int i = newIndex - 1; i >= oldIndex; --i) {
                movedMotcle.setChildIndex(i);
                movedMotcle = this.list.set(i, movedMotcle);
            }
        }
        this.clearCache();
    }

    private synchronized List<Motcle> initCache() {
        if (this.cacheList != null) {
            return this.cacheList;
        }
        List<Motcle> newCacheList = ThesaurusUtils.wrap(this.list.toArray(new Motcle[this.list.size()]));
        this.cacheList = newCacheList;
        return newCacheList;
    }

    private void clearCache() {
        this.cacheList = null;
    }
}

