/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;

class JunctionImpl
implements Junction {
    private final JunctionKey junctionKey;
    private final Map<String, Tie> tieMap = new HashMap<String, Tie>();
    private AttributesCache attributesCache = null;
    private List<Tie> cacheList;
    AbstractSubsetItem subsetItem1;
    AbstractSubsetItem subsetItem2;

    private JunctionImpl(JunctionKey junctionKey, AbstractSubsetItem subsetItem1, AbstractSubsetItem subsetItem2) {
        this.junctionKey = junctionKey;
        this.subsetItem1 = subsetItem1;
        this.subsetItem2 = subsetItem2;
    }

    boolean isEmpty() {
        return this.tieMap.isEmpty();
    }

    @Override
    public JunctionKey getJunctionKey() {
        return this.junctionKey;
    }

    @Override
    public List<Tie> getTieList() {
        List<Tie> result = this.cacheList;
        if (result == null) {
            result = this.initCache();
        }
        return result;
    }

    @Override
    public Tie getTieByMode(String mode) {
        return this.tieMap.get(mode);
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributesCache == null) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        return this.attributesCache.getAttributes();
    }

    protected synchronized boolean innerRemoveAttribute(AttributeKey attributeKey) {
        if (this.attributesCache == null) {
            return false;
        }
        return this.attributesCache.removeAttribute(attributeKey);
    }

    protected synchronized boolean innerPutAttribute(Attribute attribute) {
        if (this.attributesCache == null) {
            this.attributesCache = new AttributesCache();
        }
        return this.attributesCache.putAttribute(attribute);
    }

    protected synchronized boolean change(JunctionChange junctionChange) {
        this.clearCache();
        boolean done = false;
        for (String mode : junctionChange.getRemovedModeList()) {
            Tie currentTie = this.tieMap.remove(mode);
            if (currentTie == null) continue;
            done = true;
        }
        for (Tie changedTie : junctionChange.getChangedTieList()) {
            String mode = changedTie.getMode();
            Tie currentTie = this.tieMap.get(mode);
            if (currentTie != null) {
                if (JunctionUtils.areEquals(currentTie, changedTie)) continue;
                this.tieMap.put(mode, changedTie);
                done = true;
                continue;
            }
            this.tieMap.put(mode, changedTie);
            done = true;
        }
        return done;
    }

    private synchronized List<Tie> initCache() {
        if (this.cacheList != null) {
            return this.cacheList;
        }
        TreeMap<String, Tie> sortedMap = new TreeMap<String, Tie>(this.tieMap);
        List<Tie> list = JunctionUtils.wrap(sortedMap.values().toArray(new Tie[sortedMap.size()]));
        this.cacheList = list;
        return list;
    }

    void unlink() {
        this.subsetItem1.unlink(this.subsetItem2, this);
        this.subsetItem2.unlink(this.subsetItem1, this);
        this.subsetItem1 = null;
        this.subsetItem2 = null;
    }

    private void clearCache() {
        this.cacheList = null;
    }

    static JunctionImpl newInstance(Fichotheque fichotheque, JunctionKey junctionKey) {
        Subset subset1 = fichotheque.getSubset(junctionKey.getSubsetKey1());
        if (subset1 == null) {
            return null;
        }
        AbstractSubsetItem subsetItem1 = (AbstractSubsetItem)subset1.getSubsetItemById(junctionKey.getId1());
        if (subsetItem1 == null) {
            return null;
        }
        Subset subset2 = fichotheque.getSubset(junctionKey.getSubsetKey2());
        if (subset2 == null) {
            return null;
        }
        AbstractSubsetItem subsetItem2 = (AbstractSubsetItem)subset2.getSubsetItemById(junctionKey.getId2());
        if (subsetItem2 == null) {
            return null;
        }
        JunctionImpl junction = new JunctionImpl(junctionKey, subsetItem1, subsetItem2);
        subsetItem1.link(subsetItem2, junction);
        subsetItem2.link(subsetItem1, junction);
        return junction;
    }

    static JunctionImpl newInstance(JunctionKey junctionKey, AbstractSubsetItem subsetItem1, AbstractSubsetItem subsetItem2) {
        if (junctionKey.getOrder(subsetItem1) == 2) {
            AbstractSubsetItem temp = subsetItem1;
            subsetItem1 = subsetItem2;
            subsetItem2 = temp;
        }
        JunctionImpl junction = new JunctionImpl(junctionKey, subsetItem1, subsetItem2);
        subsetItem1.link(subsetItem2, junction);
        subsetItem2.link(subsetItem1, junction);
        return junction;
    }
}

