/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.RandomAccess;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.AttsImpl;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.Li;

public class Ul
extends AbstractList<Li>
implements FicheBlock,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 7L;
    private Li[] liArray = new Li[4];
    private int size;
    private AttsImpl attsImpl;

    public Ul(Li li) {
        if (li == null) {
            throw new IllegalArgumentException("li is null");
        }
        this.liArray[0] = li;
        this.size = 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Li get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.liArray[index];
    }

    @Override
    public boolean add(Li li) {
        if (li == null) {
            throw new NullPointerException();
        }
        this.checkLength();
        this.liArray[this.size] = li;
        ++this.size;
        return true;
    }

    private void checkLength() {
        if (this.size == this.liArray.length) {
            Li[] nv = new Li[this.size * 2];
            System.arraycopy(this.liArray, 0, nv, 0, this.size);
            this.liArray = nv;
        }
    }

    @Override
    public Atts getAtts() {
        return AttsImpl.check(this.attsImpl);
    }

    @Override
    public void putAtt(String name, String value) {
        String mode = null;
        if (name.equals("class") && (mode = this.check(value, "OL", "ol")) == null) {
            mode = this.check(value, "DL", "dl");
        }
        this.attsImpl = mode != null ? AttsImpl.put(this.attsImpl, "mode", mode) : AttsImpl.put(this.attsImpl, name, value);
    }

    private String check(String value, String prefix, String mode) {
        if (!value.startsWith(prefix)) {
            return null;
        }
        int length = prefix.length();
        if (value.length() > length) {
            this.attsImpl = AttsImpl.put(this.attsImpl, "class", value.substring(length + 1));
        }
        return mode;
    }
}

